@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Test Base Draft Package resource.
 * @property appFileName The name of the app file.
 * @property applicationName Application name
 * @property comments Comments added by user.
 * @property draftPackagePath The relative path of the folder hosting package files.
 * @property editPackage Specifies whether this draft package is used to edit a package.
 * @property executableLaunchCommand The executable launch command for script auto-fill. Will be used to run the application.
 * @property firstPartyApps The list of first party applications to test along with user application.
 * @property flightingRing The flighting ring for feature update.
 * @property galleryApps The list of gallery apps to test along with user application.
 * @property highlightedFiles The highlight files in the package.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property inplaceUpgradeOSPair Specifies the baseline os and target os for inplace upgrade.
 * @property intuneEnrollmentMetadata The metadata of Intune enrollment.
 * @property intuneMetadata Metadata used to generate draft package folder and scripts.
 * @property lastModifiedTime The UTC timestamp when the package was last modified.
 * @property name The name of the resource
 * @property packageId Specifies the package id from which the draft package copied.
 * @property packageTags Tags of the package to be created.
 * @property processName The process name for script auto-fill. Will be used to identify the application process.
 * @property provisioningState The provisioning state of the resource.
 * @property sourceType The source type.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tabState Tab state.
 * @property targetOSList Specifies the target OSs of specific OS Update types.
 * @property testTypes OOB, functional or flow driven. Mapped to the data in 'tests' property.
 * @property tests The detailed test information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useAutofill Indicates whether user choose to enable script auto-fill.
 * @property useSample Specifies whether a sample package should be used instead of the one uploaded by the user.
 * @property version Application version
 * @property workingPath The relative path for a temporarily folder for package creation work.
 */
public data class GetDraftPackageResult(
    public val appFileName: String? = null,
    public val applicationName: String? = null,
    public val comments: String? = null,
    public val draftPackagePath: String,
    public val editPackage: Boolean? = null,
    public val executableLaunchCommand: String? = null,
    public val firstPartyApps: List<FirstPartyAppDefinitionResponse>? = null,
    public val flightingRing: String? = null,
    public val galleryApps: List<GalleryAppDefinitionResponse>? = null,
    public val highlightedFiles: List<HighlightedFileResponse>? = null,
    public val id: String,
    public val inplaceUpgradeOSPair: InplaceUpgradeOSInfoResponse? = null,
    public val intuneEnrollmentMetadata: IntuneEnrollmentMetadataResponse? = null,
    public val intuneMetadata: DraftPackageIntuneAppMetadataResponse? = null,
    public val lastModifiedTime: String,
    public val name: String,
    public val packageId: String? = null,
    public val packageTags: Map<String, String>? = null,
    public val processName: String? = null,
    public val provisioningState: String,
    public val sourceType: String? = null,
    public val systemData: SystemDataResponse,
    public val tabState: TabStateResponse? = null,
    public val targetOSList: List<TargetOSInfoResponse>? = null,
    public val testTypes: List<String>? = null,
    public val tests: List<TestResponse>? = null,
    public val type: String,
    public val useAutofill: Boolean? = null,
    public val useSample: Boolean? = null,
    public val version: String? = null,
    public val workingPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetDraftPackageResult):
            GetDraftPackageResult = GetDraftPackageResult(
            appFileName = javaType.appFileName().map({ args0 -> args0 }).orElse(null),
            applicationName = javaType.applicationName().map({ args0 -> args0 }).orElse(null),
            comments = javaType.comments().map({ args0 -> args0 }).orElse(null),
            draftPackagePath = javaType.draftPackagePath(),
            editPackage = javaType.editPackage().map({ args0 -> args0 }).orElse(null),
            executableLaunchCommand = javaType.executableLaunchCommand().map({ args0 -> args0 }).orElse(null),
            firstPartyApps = javaType.firstPartyApps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.FirstPartyAppDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            flightingRing = javaType.flightingRing().map({ args0 -> args0 }).orElse(null),
            galleryApps = javaType.galleryApps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.GalleryAppDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            highlightedFiles = javaType.highlightedFiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.HighlightedFileResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            inplaceUpgradeOSPair = javaType.inplaceUpgradeOSPair().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.InplaceUpgradeOSInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            intuneEnrollmentMetadata = javaType.intuneEnrollmentMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.IntuneEnrollmentMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            intuneMetadata = javaType.intuneMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.DraftPackageIntuneAppMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            packageId = javaType.packageId().map({ args0 -> args0 }).orElse(null),
            packageTags = javaType.packageTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            processName = javaType.processName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tabState = javaType.tabState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.TabStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetOSList = javaType.targetOSList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.TargetOSInfoResponse.Companion.toKotlin(args0)
                })
            }),
            testTypes = javaType.testTypes().map({ args0 -> args0 }),
            tests = javaType.tests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.TestResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            useAutofill = javaType.useAutofill().map({ args0 -> args0 }).orElse(null),
            useSample = javaType.useSample().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
            workingPath = javaType.workingPath(),
        )
    }
}
