@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The subscription role receiver value.
 * @property role The role of the notification receiver.
 * @property subscriptionId The subscription id of the notification receiver.
 * @property subscriptionName The subscription name of the notification receiver.
 */
public data class SubscriptionReceiverValueResponse(
    public val role: String? = null,
    public val subscriptionId: String? = null,
    public val subscriptionName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.SubscriptionReceiverValueResponse):
            SubscriptionReceiverValueResponse = SubscriptionReceiverValueResponse(
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            subscriptionName = javaType.subscriptionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
