@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The information of the target OS to be tested.
 * @property baselineOSs Specifies the baseline OSs to be tested.
 * @property insiderChannelIds Insider Channel Ids. Only used for feature update.
 * @property osUpdateType Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
 * @property targetOSImageIds Specifies the ids of the target OSs from Custom Images to be tested.
 * @property targetOSs Specifies the target OSs to be tested.
 */
public data class TargetOSInfoResponse(
    public val baselineOSs: List<String>? = null,
    public val insiderChannelIds: List<String>? = null,
    public val osUpdateType: String,
    public val targetOSImageIds: List<String>? = null,
    public val targetOSs: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.TargetOSInfoResponse):
            TargetOSInfoResponse = TargetOSInfoResponse(
            baselineOSs = javaType.baselineOSs().map({ args0 -> args0 }),
            insiderChannelIds = javaType.insiderChannelIds().map({ args0 -> args0 }),
            osUpdateType = javaType.osUpdateType(),
            targetOSImageIds = javaType.targetOSImageIds().map({ args0 -> args0 }),
            targetOSs = javaType.targetOSs().map({ args0 -> args0 }),
        )
    }
}
