@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The detailed result of a validation or rule checking.
 * @property message Message for clarification.
 * @property result Indicates if the validation or rule checking is passed.
 * @property verificationName The name of the verification rule.
 */
public data class VerificationResultResponse(
    public val message: String? = null,
    public val result: String,
    public val verificationName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.VerificationResultResponse):
            VerificationResultResponse = VerificationResultResponse(
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            result = javaType.result(),
            verificationName = javaType.verificationName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
