@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AccessPolicy].
 */
@PulumiTagMarker
public class AccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPolicyArgs = AccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPolicyArgsBuilder.() -> Unit) {
        val builder = AccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.timeseriesinsights.AccessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessPolicy(builtJavaResource)
    }
}

/**
 * An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * Other available API versions: 2017-11-15, 2021-06-30-preview.
 * ## Example Usage
 * ### AccessPoliciesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicy = new AzureNative.TimeSeriesInsights.AccessPolicy("accessPolicy", new()
 *     {
 *         AccessPolicyName = "ap1",
 *         Description = "some description",
 *         EnvironmentName = "env1",
 *         PrincipalObjectId = "aGuid",
 *         ResourceGroupName = "rg1",
 *         Roles = new[]
 *         {
 *             AzureNative.TimeSeriesInsights.AccessPolicyRole.Reader,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewAccessPolicy(ctx, "accessPolicy", &timeseriesinsights.AccessPolicyArgs{
 * 			AccessPolicyName:  pulumi.String("ap1"),
 * 			Description:       pulumi.String("some description"),
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			PrincipalObjectId: pulumi.String("aGuid"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Roles: pulumi.StringArray{
 * 				pulumi.String(timeseriesinsights.AccessPolicyRoleReader),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.AccessPolicy;
 * import com.pulumi.azurenative.timeseriesinsights.AccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicy = new AccessPolicy("accessPolicy", AccessPolicyArgs.builder()
 *             .accessPolicyName("ap1")
 *             .description("some description")
 *             .environmentName("env1")
 *             .principalObjectId("aGuid")
 *             .resourceGroupName("rg1")
 *             .roles("Reader")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:AccessPolicy ap1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies/{accessPolicyName}
 * ```
 */
public class AccessPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.timeseriesinsights.AccessPolicy,
) : KotlinCustomResource(javaResource, AccessPolicyMapper) {
    /**
     * An description of the access policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The objectId of the principal in Azure Active Directory.
     */
    public val principalObjectId: Output<String>?
        get() = javaResource.principalObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of roles the principal is assigned on the environment.
     */
    public val roles: Output<List<String>>?
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessPolicyMapper : ResourceMapper<AccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.timeseriesinsights.AccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessPolicy = AccessPolicy(
        javaResource as
            com.pulumi.azurenative.timeseriesinsights.AccessPolicy,
    )
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPolicy].
 */
public suspend fun accessPolicy(
    name: String,
    block: suspend AccessPolicyResourceBuilder.() -> Unit,
): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPolicy(name: String): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
