@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStatusResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.TimeSeriesIdPropertyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStatusResponse.Companion.toKotlin as environmentStatusResponseToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.TimeSeriesIdPropertyResponse.Companion.toKotlin as timeSeriesIdPropertyResponseToKotlin

/**
 * Builder for [Gen1Environment].
 */
@PulumiTagMarker
public class Gen1EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Gen1EnvironmentArgs = Gen1EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Gen1EnvironmentArgsBuilder.() -> Unit) {
        val builder = Gen1EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gen1Environment {
        val builtJavaResource =
            com.pulumi.azurenative.timeseriesinsights.Gen1Environment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Gen1Environment(builtJavaResource)
    }
}

/**
 * An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### EnvironmentsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gen1Environment = new AzureNative.TimeSeriesInsights.Gen1Environment("gen1Environment", new()
 *     {
 *         DataRetentionTime = "P31D",
 *         EnvironmentName = "env1",
 *         Kind = "Gen1",
 *         Location = "West US",
 *         PartitionKeyProperties = new[]
 *         {
 *             new AzureNative.TimeSeriesInsights.Inputs.TimeSeriesIdPropertyArgs
 *             {
 *                 Name = "DeviceId1",
 *                 Type = AzureNative.TimeSeriesInsights.PropertyType.String,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.TimeSeriesInsights.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.TimeSeriesInsights.SkuName.S1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewGen1Environment(ctx, "gen1Environment", &timeseriesinsights.Gen1EnvironmentArgs{
 * 			DataRetentionTime: pulumi.String("P31D"),
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			Kind:              pulumi.String("Gen1"),
 * 			Location:          pulumi.String("West US"),
 * 			PartitionKeyProperties: timeseriesinsights.TimeSeriesIdPropertyArray{
 * 				&timeseriesinsights.TimeSeriesIdPropertyArgs{
 * 					Name: pulumi.String("DeviceId1"),
 * 					Type: pulumi.String(timeseriesinsights.PropertyTypeString),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &timeseriesinsights.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(timeseriesinsights.SkuNameS1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.Gen1Environment;
 * import com.pulumi.azurenative.timeseriesinsights.Gen1EnvironmentArgs;
 * import com.pulumi.azurenative.timeseriesinsights.inputs.TimeSeriesIdPropertyArgs;
 * import com.pulumi.azurenative.timeseriesinsights.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gen1Environment = new Gen1Environment("gen1Environment", Gen1EnvironmentArgs.builder()
 *             .dataRetentionTime("P31D")
 *             .environmentName("env1")
 *             .kind("Gen1")
 *             .location("West US")
 *             .partitionKeyProperties(TimeSeriesIdPropertyArgs.builder()
 *                 .name("DeviceId1")
 *                 .type("String")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .name("S1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:Gen1Environment env1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}
 * ```
 */
public class Gen1Environment internal constructor(
    override val javaResource: com.pulumi.azurenative.timeseriesinsights.Gen1Environment,
) : KotlinCustomResource(javaResource, Gen1EnvironmentMapper) {
    /**
     * The time the resource was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The fully qualified domain name used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
     */
    public val dataAccessFqdn: Output<String>
        get() = javaResource.dataAccessFqdn().applyValue({ args0 -> args0 })

    /**
     * An id used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
     */
    public val dataAccessId: Output<String>
        get() = javaResource.dataAccessId().applyValue({ args0 -> args0 })

    /**
     * ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
     */
    public val dataRetentionTime: Output<String>
        get() = javaResource.dataRetentionTime().applyValue({ args0 -> args0 })

    /**
     * The kind of the environment.
     * Expected value is 'Gen1'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    public val partitionKeyProperties: Output<List<TimeSeriesIdPropertyResponse>>?
        get() = javaResource.partitionKeyProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        timeSeriesIdPropertyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * An object that represents the status of the environment, and its internal state in the Time Series Insights service.
     */
    public val status: Output<EnvironmentStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentStatusResponseToKotlin(args0)
            })
        })

    /**
     * The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
     */
    public val storageLimitExceededBehavior: Output<String>?
        get() = javaResource.storageLimitExceededBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object Gen1EnvironmentMapper : ResourceMapper<Gen1Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.timeseriesinsights.Gen1Environment::class == javaResource::class

    override fun map(javaResource: Resource): Gen1Environment = Gen1Environment(
        javaResource as
            com.pulumi.azurenative.timeseriesinsights.Gen1Environment,
    )
}

/**
 * @see [Gen1Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gen1Environment].
 */
public suspend fun gen1Environment(
    name: String,
    block: suspend Gen1EnvironmentResourceBuilder.() -> Unit,
): Gen1Environment {
    val builder = Gen1EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gen1Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gen1Environment(name: String): Gen1Environment {
    val builder = Gen1EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
