@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.Gen1EnvironmentArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.StorageLimitExceededBehavior
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.TimeSeriesIdPropertyArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.TimeSeriesIdPropertyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### EnvironmentsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gen1Environment = new AzureNative.TimeSeriesInsights.Gen1Environment("gen1Environment", new()
 *     {
 *         DataRetentionTime = "P31D",
 *         EnvironmentName = "env1",
 *         Kind = "Gen1",
 *         Location = "West US",
 *         PartitionKeyProperties = new[]
 *         {
 *             new AzureNative.TimeSeriesInsights.Inputs.TimeSeriesIdPropertyArgs
 *             {
 *                 Name = "DeviceId1",
 *                 Type = AzureNative.TimeSeriesInsights.PropertyType.String,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.TimeSeriesInsights.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.TimeSeriesInsights.SkuName.S1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewGen1Environment(ctx, "gen1Environment", &timeseriesinsights.Gen1EnvironmentArgs{
 * 			DataRetentionTime: pulumi.String("P31D"),
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			Kind:              pulumi.String("Gen1"),
 * 			Location:          pulumi.String("West US"),
 * 			PartitionKeyProperties: timeseriesinsights.TimeSeriesIdPropertyArray{
 * 				&timeseriesinsights.TimeSeriesIdPropertyArgs{
 * 					Name: pulumi.String("DeviceId1"),
 * 					Type: pulumi.String(timeseriesinsights.PropertyTypeString),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &timeseriesinsights.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String(timeseriesinsights.SkuNameS1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.Gen1Environment;
 * import com.pulumi.azurenative.timeseriesinsights.Gen1EnvironmentArgs;
 * import com.pulumi.azurenative.timeseriesinsights.inputs.TimeSeriesIdPropertyArgs;
 * import com.pulumi.azurenative.timeseriesinsights.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gen1Environment = new Gen1Environment("gen1Environment", Gen1EnvironmentArgs.builder()
 *             .dataRetentionTime("P31D")
 *             .environmentName("env1")
 *             .kind("Gen1")
 *             .location("West US")
 *             .partitionKeyProperties(TimeSeriesIdPropertyArgs.builder()
 *                 .name("DeviceId1")
 *                 .type("String")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .name("S1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:Gen1Environment env1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}
 * ```
 * @property dataRetentionTime ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
 * @property environmentName Name of the environment
 * @property kind The kind of the environment.
 * Expected value is 'Gen1'.
 * @property location The location of the resource.
 * @property partitionKeyProperties The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property sku The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
 * @property storageLimitExceededBehavior The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
 * @property tags Key-value pairs of additional properties for the resource.
 */
public data class Gen1EnvironmentArgs(
    public val dataRetentionTime: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val partitionKeyProperties: Output<List<TimeSeriesIdPropertyArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val storageLimitExceededBehavior: Output<Either<String, StorageLimitExceededBehavior>>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.Gen1EnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.Gen1EnvironmentArgs =
        com.pulumi.azurenative.timeseriesinsights.Gen1EnvironmentArgs.builder()
            .dataRetentionTime(dataRetentionTime?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .partitionKeyProperties(
                partitionKeyProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageLimitExceededBehavior(
                storageLimitExceededBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [Gen1EnvironmentArgs].
 */
@PulumiTagMarker
public class Gen1EnvironmentArgsBuilder internal constructor() {
    private var dataRetentionTime: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var partitionKeyProperties: Output<List<TimeSeriesIdPropertyArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var storageLimitExceededBehavior: Output<Either<String, StorageLimitExceededBehavior>>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
     */
    @JvmName("sgcynwwwkojycsmt")
    public suspend fun dataRetentionTime(`value`: Output<String>) {
        this.dataRetentionTime = value
    }

    /**
     * @param value Name of the environment
     */
    @JvmName("urmwurukpxdidjot")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The kind of the environment.
     * Expected value is 'Gen1'.
     */
    @JvmName("yodmhkkiphngcfox")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("kjxihrltinedubkq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("tkfwnslojboflate")
    public suspend fun partitionKeyProperties(`value`: Output<List<TimeSeriesIdPropertyArgs>>) {
        this.partitionKeyProperties = value
    }

    @JvmName("pbfhxitxfqalmqts")
    public suspend fun partitionKeyProperties(vararg values: Output<TimeSeriesIdPropertyArgs>) {
        this.partitionKeyProperties = Output.all(values.asList())
    }

    /**
     * @param values The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("bnhpfteinpsfjedr")
    public suspend fun partitionKeyProperties(values: List<Output<TimeSeriesIdPropertyArgs>>) {
        this.partitionKeyProperties = Output.all(values)
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("teqmnvljnbydenow")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    @JvmName("fdknhlhcxbpjrqeh")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
     */
    @JvmName("fiqrtcmbruhyjisg")
    public suspend
    fun storageLimitExceededBehavior(`value`: Output<Either<String, StorageLimitExceededBehavior>>) {
        this.storageLimitExceededBehavior = value
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("ixkqkhbetvslkyxd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
     */
    @JvmName("mbnxlsduakxssxjs")
    public suspend fun dataRetentionTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRetentionTime = mapped
    }

    /**
     * @param value Name of the environment
     */
    @JvmName("rnrffqrxttryulvu")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The kind of the environment.
     * Expected value is 'Gen1'.
     */
    @JvmName("wpxwvxkmeinityhk")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("agfwyylldvmwsfja")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("gujvcejsxdcjshhf")
    public suspend fun partitionKeyProperties(`value`: List<TimeSeriesIdPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeyProperties = mapped
    }

    /**
     * @param argument The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("bfiyhkrajgsuxlaa")
    public suspend
    fun partitionKeyProperties(argument: List<suspend TimeSeriesIdPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TimeSeriesIdPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeyProperties = mapped
    }

    /**
     * @param argument The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("lgbjntoxseqtpdlq")
    public suspend fun partitionKeyProperties(
        vararg
        argument: suspend TimeSeriesIdPropertyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TimeSeriesIdPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeyProperties = mapped
    }

    /**
     * @param argument The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("vemkpqxionhmxmbq")
    public suspend
    fun partitionKeyProperties(argument: suspend TimeSeriesIdPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TimeSeriesIdPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.partitionKeyProperties = mapped
    }

    /**
     * @param values The list of event properties which will be used to partition data in the environment. Currently, only a single partition key property is supported.
     */
    @JvmName("glkpxobarobbkyaw")
    public suspend fun partitionKeyProperties(vararg values: TimeSeriesIdPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeyProperties = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("gvicxchknaskcxyc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    @JvmName("tjvuwedokphdwbhc")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    @JvmName("lpjbhkrxmeuuxfsw")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
     */
    @JvmName("fxpvbkdjrsjddfif")
    public suspend
    fun storageLimitExceededBehavior(`value`: Either<String, StorageLimitExceededBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLimitExceededBehavior = mapped
    }

    /**
     * @param value The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
     */
    @JvmName("wcemwxggwgpmmtoe")
    public fun storageLimitExceededBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageLimitExceededBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageLimitExceededBehavior = mapped
    }

    /**
     * @param value The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
     */
    @JvmName("wpsjhsbmhkiyhxdg")
    public fun storageLimitExceededBehavior(`value`: StorageLimitExceededBehavior) {
        val toBeMapped = Either.ofRight<String, StorageLimitExceededBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageLimitExceededBehavior = mapped
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("jdhxhmsdqcymedwj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional properties for the resource.
     */
    @JvmName("xyqvoipbgpdjmcnu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): Gen1EnvironmentArgs = Gen1EnvironmentArgs(
        dataRetentionTime = dataRetentionTime,
        environmentName = environmentName,
        kind = kind,
        location = location,
        partitionKeyProperties = partitionKeyProperties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        storageLimitExceededBehavior = storageLimitExceededBehavior,
        tags = tags,
    )
}
