@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2021-03-31-preview. Prior API version in Azure Native 1.x: 2021-03-31-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.TimeSeriesInsights.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         EnvironmentName = "myEnvironment",
 *         PrivateEndpointConnectionName = "myPrivateEndpointConnectionName",
 *         PrivateLinkServiceConnectionState = new AzureNative.TimeSeriesInsights.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Rejected for some reason",
 *             Status = AzureNative.TimeSeriesInsights.PrivateEndpointServiceConnectionStatus.Rejected,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &timeseriesinsights.PrivateEndpointConnectionArgs{
 * 			EnvironmentName:               pulumi.String("myEnvironment"),
 * 			PrivateEndpointConnectionName: pulumi.String("myPrivateEndpointConnectionName"),
 * 			PrivateLinkServiceConnectionState: &timeseriesinsights.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Rejected for some reason"),
 * 				Status:      pulumi.String(timeseriesinsights.PrivateEndpointServiceConnectionStatusRejected),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.PrivateEndpointConnection;
 * import com.pulumi.azurenative.timeseriesinsights.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.timeseriesinsights.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .environmentName("myEnvironment")
 *             .privateEndpointConnectionName("myPrivateEndpointConnectionName")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Rejected for some reason")
 *                 .status("Rejected")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:PrivateEndpointConnection myPrivateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property groupIds The provisioning state of the private endpoint connection resource.
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class PrivateEndpointConnectionArgs(
    public val environmentName: Output<String>? = null,
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.timeseriesinsights.PrivateEndpointConnectionArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var groupIds: Output<List<String>>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("rlqwyxukfdlofemd")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The provisioning state of the private endpoint connection resource.
     */
    @JvmName("yrpyhudfrjtcwerj")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("iynmvaalheatbgxd")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The provisioning state of the private endpoint connection resource.
     */
    @JvmName("wtqorfktrjgirhtc")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("dpphjghslcshsqae")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("wucabnsgqolmkogx")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("vnovajmuvrqwcoxi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("kjektraubiydndpi")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The provisioning state of the private endpoint connection resource.
     */
    @JvmName("kgvfurbnxgsaywfy")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The provisioning state of the private endpoint connection resource.
     */
    @JvmName("olwqlihqnukhleme")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("fgelhrurjmgvjvxd")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("ufoasrecyyuiakgl")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("yatmawfyqiibwhal")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("jgjxmqyvmnbutfwb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        environmentName = environmentName,
        groupIds = groupIds,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
