@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
 */
public enum class DataStringComparisonBehavior(
    public val javaValue:
    com.pulumi.azurenative.timeseriesinsights.enums.DataStringComparisonBehavior,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.enums.DataStringComparisonBehavior> {
    Ordinal(com.pulumi.azurenative.timeseriesinsights.enums.DataStringComparisonBehavior.Ordinal),
    OrdinalIgnoreCase(com.pulumi.azurenative.timeseriesinsights.enums.DataStringComparisonBehavior.OrdinalIgnoreCase),
    ;

    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.enums.DataStringComparisonBehavior = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.enums.DataStringComparisonBehavior):
            DataStringComparisonBehavior =
            DataStringComparisonBehavior.values().first { it.javaValue == javaType }
    }
}
