@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.LocalTimestampFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
 * @property format An enum that represents the format of the local timestamp property that needs to be set.
 * @property timeZoneOffset An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
 */
public data class LocalTimestampArgs(
    public val format: Output<Either<String, LocalTimestampFormat>>? = null,
    public val timeZoneOffset: Output<LocalTimestampTimeZoneOffsetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampArgs.builder()
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeZoneOffset(
                timeZoneOffset?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LocalTimestampArgs].
 */
@PulumiTagMarker
public class LocalTimestampArgsBuilder internal constructor() {
    private var format: Output<Either<String, LocalTimestampFormat>>? = null

    private var timeZoneOffset: Output<LocalTimestampTimeZoneOffsetArgs>? = null

    /**
     * @param value An enum that represents the format of the local timestamp property that needs to be set.
     */
    @JvmName("twgkaxdecynhksje")
    public suspend fun format(`value`: Output<Either<String, LocalTimestampFormat>>) {
        this.format = value
    }

    /**
     * @param value An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
     */
    @JvmName("ipwdvtftofksnqyl")
    public suspend fun timeZoneOffset(`value`: Output<LocalTimestampTimeZoneOffsetArgs>) {
        this.timeZoneOffset = value
    }

    /**
     * @param value An enum that represents the format of the local timestamp property that needs to be set.
     */
    @JvmName("tsvxparvtakxebil")
    public suspend fun format(`value`: Either<String, LocalTimestampFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value An enum that represents the format of the local timestamp property that needs to be set.
     */
    @JvmName("ccaqyqwqqutnjlfw")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LocalTimestampFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value An enum that represents the format of the local timestamp property that needs to be set.
     */
    @JvmName("unjatcufqbxokaqr")
    public fun format(`value`: LocalTimestampFormat) {
        val toBeMapped = Either.ofRight<String, LocalTimestampFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
     */
    @JvmName("lhtxoirekisdhutc")
    public suspend fun timeZoneOffset(`value`: LocalTimestampTimeZoneOffsetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZoneOffset = mapped
    }

    /**
     * @param argument An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
     */
    @JvmName("lilwvefwioxehoum")
    public suspend
    fun timeZoneOffset(argument: suspend LocalTimestampTimeZoneOffsetArgsBuilder.() -> Unit) {
        val toBeMapped = LocalTimestampTimeZoneOffsetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeZoneOffset = mapped
    }

    internal fun build(): LocalTimestampArgs = LocalTimestampArgs(
        format = format,
        timeZoneOffset = timeZoneOffset,
    )
}
