@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.Suppress

/**
 * An object that represents the status of the environment, and its internal state in the Time Series Insights service.
 * @property ingress An object that represents the status of ingress on an environment.
 * @property warmStorage An object that represents the status of warm storage on an environment.
 */
public data class EnvironmentStatusResponse(
    public val ingress: IngressEnvironmentStatusResponse,
    public val warmStorage: WarmStorageEnvironmentStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.EnvironmentStatusResponse):
            EnvironmentStatusResponse = EnvironmentStatusResponse(
            ingress = javaType.ingress().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.IngressEnvironmentStatusResponse.Companion.toKotlin(args0)
            }),
            warmStorage = javaType.warmStorage().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.WarmStorageEnvironmentStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
