@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.
 * @property description An description of the access policy.
 * @property id Resource Id
 * @property name Resource name
 * @property principalObjectId The objectId of the principal in Azure Active Directory.
 * @property roles The list of roles the principal is assigned on the environment.
 * @property type Resource type
 */
public data class GetAccessPolicyResult(
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val principalObjectId: String? = null,
    public val roles: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.GetAccessPolicyResult):
            GetAccessPolicyResult = GetAccessPolicyResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            principalObjectId = javaType.principalObjectId().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
