@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.EdgeModuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The representation of an edge module.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * ## Example Usage
 * ### Registers an edge module.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var edgeModule = new AzureNative.VideoAnalyzer.EdgeModule("edgeModule", new()
 *     {
 *         AccountName = "testaccount2",
 *         EdgeModuleName = "edgeModule1",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewEdgeModule(ctx, "edgeModule", &videoanalyzer.EdgeModuleArgs{
 * 			AccountName:       pulumi.String("testaccount2"),
 * 			EdgeModuleName:    pulumi.String("edgeModule1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.EdgeModule;
 * import com.pulumi.azurenative.videoanalyzer.EdgeModuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var edgeModule = new EdgeModule("edgeModule", EdgeModuleArgs.builder()
 *             .accountName("testaccount2")
 *             .edgeModuleName("edgeModule1")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:EdgeModule edgeModule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/edgeModules/{edgeModuleName}
 * ```
 * @property accountName The Azure Video Analyzer account name.
 * @property edgeModuleName The Edge Module name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class EdgeModuleArgs(
    public val accountName: Output<String>? = null,
    public val edgeModuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.EdgeModuleArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.EdgeModuleArgs =
        com.pulumi.azurenative.videoanalyzer.EdgeModuleArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .edgeModuleName(edgeModuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdgeModuleArgs].
 */
@PulumiTagMarker
public class EdgeModuleArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var edgeModuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("dfnqtdrhxklanppu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Edge Module name.
     */
    @JvmName("dqglqrqsxujvwsxm")
    public suspend fun edgeModuleName(`value`: Output<String>) {
        this.edgeModuleName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("raehqadffdqsviak")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("hjeallvfpdqwkyll")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Edge Module name.
     */
    @JvmName("xvbyjewjyhjlkdqb")
    public suspend fun edgeModuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edgeModuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ktqjkafuewnugxro")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): EdgeModuleArgs = EdgeModuleArgs(
        accountName = accountName,
        edgeModuleName = edgeModuleName,
        resourceGroupName = resourceGroupName,
    )
}
