@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDefinitionResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin as parameterDefinitionResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LivePipeline].
 */
@PulumiTagMarker
public class LivePipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LivePipelineArgs = LivePipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LivePipelineArgsBuilder.() -> Unit) {
        val builder = LivePipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LivePipeline {
        val builtJavaResource =
            com.pulumi.azurenative.videoanalyzer.LivePipeline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LivePipeline(builtJavaResource)
    }
}

/**
 * Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and publishing of content for a unique RTSP camera.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### Create or update a live pipeline
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var livePipeline = new AzureNative.VideoAnalyzer.LivePipeline("livePipeline", new()
 *     {
 *         AccountName = "testaccount2",
 *         BitrateKbps = 500,
 *         Description = "Live Pipeline 1 Description",
 *         LivePipelineName = "livePipeline1",
 *         Parameters = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDefinitionArgs
 *             {
 *                 Name = "rtspUrlParameter",
 *                 Value = "rtsp://contoso.com/stream",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         TopologyName = "pipelinetopology1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewLivePipeline(ctx, "livePipeline", &videoanalyzer.LivePipelineArgs{
 * 			AccountName:      pulumi.String("testaccount2"),
 * 			BitrateKbps:      pulumi.Int(500),
 * 			Description:      pulumi.String("Live Pipeline 1 Description"),
 * 			LivePipelineName: pulumi.String("livePipeline1"),
 * 			Parameters: videoanalyzer.ParameterDefinitionArray{
 * 				&videoanalyzer.ParameterDefinitionArgs{
 * 					Name:  pulumi.String("rtspUrlParameter"),
 * 					Value: pulumi.String("rtsp://contoso.com/stream"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			TopologyName:      pulumi.String("pipelinetopology1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.LivePipeline;
 * import com.pulumi.azurenative.videoanalyzer.LivePipelineArgs;
 * import com.pulumi.azurenative.videoanalyzer.inputs.ParameterDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var livePipeline = new LivePipeline("livePipeline", LivePipelineArgs.builder()
 *             .accountName("testaccount2")
 *             .bitrateKbps(500)
 *             .description("Live Pipeline 1 Description")
 *             .livePipelineName("livePipeline1")
 *             .parameters(ParameterDefinitionArgs.builder()
 *                 .name("rtspUrlParameter")
 *                 .value("rtsp://contoso.com/stream")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .topologyName("pipelinetopology1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:LivePipeline livePipeline1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/livePipelines/{livePipelineName}
 * ```
 */
public class LivePipeline internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.LivePipeline,
) : KotlinCustomResource(javaResource, LivePipelineMapper) {
    /**
     * Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
     */
    public val bitrateKbps: Output<Int>
        get() = javaResource.bitrateKbps().applyValue({ args0 -> args0 })

    /**
     * An optional description for the pipeline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    public val parameters: Output<List<ParameterDefinitionResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> parameterDefinitionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Current state of the pipeline (read-only).
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
     */
    public val topologyName: Output<String>
        get() = javaResource.topologyName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LivePipelineMapper : ResourceMapper<LivePipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.LivePipeline::class == javaResource::class

    override fun map(javaResource: Resource): LivePipeline = LivePipeline(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.LivePipeline,
    )
}

/**
 * @see [LivePipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LivePipeline].
 */
public suspend fun livePipeline(
    name: String,
    block: suspend LivePipelineResourceBuilder.() -> Unit,
): LivePipeline {
    val builder = LivePipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LivePipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun livePipeline(name: String): LivePipeline {
    val builder = LivePipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
