@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * RSA algorithm to be used: RS256, RS384 or RS512.
 */
public enum class AccessPolicyRsaAlgo(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo> {
    /**
     * RS256
     */
    RS256(com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo.RS256),

    /**
     * RS384
     */
    RS384(com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo.RS384),

    /**
     * RS512
     */
    RS512(com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo.RS512),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.AccessPolicyRsaAlgo):
            AccessPolicyRsaAlgo = AccessPolicyRsaAlgo.values().first { it.javaValue == javaType }
    }
}
