@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.EncoderProcessorArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Encoder processor allows for encoding of the input content. For example, it can used to change the resolution from 4K to 1280x720.
 * @property inputs An array of upstream node references within the topology to be used as inputs for this node.
 * @property name Node name. Must be unique within the topology.
 * @property preset The encoder preset, which defines the recipe or instructions on how the input content should be processed.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
 */
public data class EncoderProcessorArgs(
    public val inputs: Output<List<NodeInputArgs>>,
    public val name: Output<String>,
    public val preset: Output<Either<EncoderCustomPresetArgs, EncoderSystemPresetArgs>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.EncoderProcessorArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.EncoderProcessorArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.EncoderProcessorArgs.builder()
            .inputs(inputs.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .preset(
                preset.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncoderProcessorArgs].
 */
@PulumiTagMarker
public class EncoderProcessorArgsBuilder internal constructor() {
    private var inputs: Output<List<NodeInputArgs>>? = null

    private var name: Output<String>? = null

    private var preset: Output<Either<EncoderCustomPresetArgs, EncoderSystemPresetArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("ggetghdummkdmqos")
    public suspend fun inputs(`value`: Output<List<NodeInputArgs>>) {
        this.inputs = value
    }

    @JvmName("mhhcmaqvbjlixdvg")
    public suspend fun inputs(vararg values: Output<NodeInputArgs>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("gmdeipsfkvujbvvb")
    public suspend fun inputs(values: List<Output<NodeInputArgs>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value Node name. Must be unique within the topology.
     */
    @JvmName("tlfujnpmpynqsfuk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The encoder preset, which defines the recipe or instructions on how the input content should be processed.
     */
    @JvmName("csbmlfjqngruente")
    public suspend
    fun preset(`value`: Output<Either<EncoderCustomPresetArgs, EncoderSystemPresetArgs>>) {
        this.preset = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
     */
    @JvmName("cwodrqlgsvwlpvov")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("ybblfidivgdulytm")
    public suspend fun inputs(`value`: List<NodeInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("crvvgerggghbwfxm")
    public suspend fun inputs(argument: List<suspend NodeInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { NodeInputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("upxgjyxsilaoqyel")
    public suspend fun inputs(vararg argument: suspend NodeInputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { NodeInputArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("wcecxtxbqcjjkbrq")
    public suspend fun inputs(argument: suspend NodeInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodeInputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param values An array of upstream node references within the topology to be used as inputs for this node.
     */
    @JvmName("nwpputojepwhmibs")
    public suspend fun inputs(vararg values: NodeInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Node name. Must be unique within the topology.
     */
    @JvmName("vpwaiedphuundfkg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The encoder preset, which defines the recipe or instructions on how the input content should be processed.
     */
    @JvmName("wffksjebevpycsjx")
    public suspend fun preset(`value`: Either<EncoderCustomPresetArgs, EncoderSystemPresetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preset = mapped
    }

    /**
     * @param value The encoder preset, which defines the recipe or instructions on how the input content should be processed.
     */
    @JvmName("hoktoollsifdavqu")
    public fun preset(`value`: EncoderCustomPresetArgs) {
        val toBeMapped = Either.ofLeft<EncoderCustomPresetArgs, EncoderSystemPresetArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preset = mapped
    }

    /**
     * @param value The encoder preset, which defines the recipe or instructions on how the input content should be processed.
     */
    @JvmName("yyetwpjfdnhbrvka")
    public fun preset(`value`: EncoderSystemPresetArgs) {
        val toBeMapped = Either.ofRight<EncoderCustomPresetArgs, EncoderSystemPresetArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preset = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
     */
    @JvmName("juxusqnqgqmyvjjj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncoderProcessorArgs = EncoderProcessorArgs(
        inputs = inputs ?: throw PulumiNullFieldException("inputs"),
        name = name ?: throw PulumiNullFieldException("name"),
        preset = preset ?: throw PulumiNullFieldException("preset"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
