@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GetLivePipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Azure Video Analyzer account name.
 * @property livePipelineName Live pipeline unique identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLivePipelinePlainArgs(
    public val accountName: String,
    public val livePipelineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GetLivePipelinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GetLivePipelinePlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GetLivePipelinePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .livePipelineName(livePipelineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLivePipelinePlainArgs].
 */
@PulumiTagMarker
public class GetLivePipelinePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var livePipelineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("ajxdgynwbisivvno")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Live pipeline unique identifier.
     */
    @JvmName("ocnxqjrcrlnqmloi")
    public suspend fun livePipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.livePipelineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iklbbqokdmgevvpl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLivePipelinePlainArgs = GetLivePipelinePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        livePipelineName = livePipelineName ?: throw PulumiNullFieldException("livePipelineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
