@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.IotHubArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The IoT Hub details.
 * @property id The IoT Hub resource identifier.
 * @property identity The IoT Hub identity.
 */
public data class IotHubArgs(
    public val id: Output<String>,
    public val identity: Output<ResourceIdentityArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.IotHubArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.IotHubArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.IotHubArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .identity(identity.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IotHubArgs].
 */
@PulumiTagMarker
public class IotHubArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    /**
     * @param value The IoT Hub resource identifier.
     */
    @JvmName("lfejpglvvhnyuqah")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The IoT Hub identity.
     */
    @JvmName("yedorgbhakxmllsp")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The IoT Hub resource identifier.
     */
    @JvmName("uyeoyflnltvauusn")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The IoT Hub identity.
     */
    @JvmName("gnixftydlxtdjbnf")
    public suspend fun identity(`value`: ResourceIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The IoT Hub identity.
     */
    @JvmName("vqygiiqrprefvjhj")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    internal fun build(): IotHubArgs = IotHubArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        identity = identity ?: throw PulumiNullFieldException("identity"),
    )
}
