@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.JwtAuthenticationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties for access validation based on JSON Web Tokens (JWT).
 * @property audiences List of expected token audiences. Token audience is valid if it matches at least one of the given values.
 * @property claims List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
 * @property issuers List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
 * @property keys List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
 */
public data class JwtAuthenticationArgs(
    public val audiences: Output<List<String>>? = null,
    public val claims: Output<List<TokenClaimArgs>>? = null,
    public val issuers: Output<List<String>>? = null,
    public val keys: Output<List<Either<EccTokenKeyArgs, RsaTokenKeyArgs>>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.JwtAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.JwtAuthenticationArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.JwtAuthenticationArgs.builder()
            .audiences(audiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .claims(claims?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .issuers(issuers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keys(
                keys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JwtAuthenticationArgs].
 */
@PulumiTagMarker
public class JwtAuthenticationArgsBuilder internal constructor() {
    private var audiences: Output<List<String>>? = null

    private var claims: Output<List<TokenClaimArgs>>? = null

    private var issuers: Output<List<String>>? = null

    private var keys: Output<List<Either<EccTokenKeyArgs, RsaTokenKeyArgs>>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of expected token audiences. Token audience is valid if it matches at least one of the given values.
     */
    @JvmName("rhtbllkwckculqnh")
    public suspend fun audiences(`value`: Output<List<String>>) {
        this.audiences = value
    }

    @JvmName("sertqykhkwppbveu")
    public suspend fun audiences(vararg values: Output<String>) {
        this.audiences = Output.all(values.asList())
    }

    /**
     * @param values List of expected token audiences. Token audience is valid if it matches at least one of the given values.
     */
    @JvmName("umfcxuodkrgkinxd")
    public suspend fun audiences(values: List<Output<String>>) {
        this.audiences = Output.all(values)
    }

    /**
     * @param value List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("ctdlrygtsutegluc")
    public suspend fun claims(`value`: Output<List<TokenClaimArgs>>) {
        this.claims = value
    }

    @JvmName("irelxowgsnjbjvxs")
    public suspend fun claims(vararg values: Output<TokenClaimArgs>) {
        this.claims = Output.all(values.asList())
    }

    /**
     * @param values List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("svrawvfucijmepfy")
    public suspend fun claims(values: List<Output<TokenClaimArgs>>) {
        this.claims = Output.all(values)
    }

    /**
     * @param value List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
     */
    @JvmName("ljcakislwynwlvhg")
    public suspend fun issuers(`value`: Output<List<String>>) {
        this.issuers = value
    }

    @JvmName("yplxqjcwklymmxeh")
    public suspend fun issuers(vararg values: Output<String>) {
        this.issuers = Output.all(values.asList())
    }

    /**
     * @param values List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
     */
    @JvmName("ltjoghywdsuymeny")
    public suspend fun issuers(values: List<Output<String>>) {
        this.issuers = Output.all(values)
    }

    /**
     * @param value List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
     */
    @JvmName("bwekruntsdhjwnfs")
    public suspend fun keys(`value`: Output<List<Either<EccTokenKeyArgs, RsaTokenKeyArgs>>>) {
        this.keys = value
    }

    @JvmName("rkbcwadyiaervofo")
    public suspend fun keys(vararg values: Output<Either<EccTokenKeyArgs, RsaTokenKeyArgs>>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
     */
    @JvmName("njonxvrdmkawidcr")
    public suspend fun keys(values: List<Output<Either<EccTokenKeyArgs, RsaTokenKeyArgs>>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
     */
    @JvmName("wgfsyjlsxfasywyk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of expected token audiences. Token audience is valid if it matches at least one of the given values.
     */
    @JvmName("olislxfwfggvrawu")
    public suspend fun audiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param values List of expected token audiences. Token audience is valid if it matches at least one of the given values.
     */
    @JvmName("ceuytaajrojjfydp")
    public suspend fun audiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param value List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("iefelcdfcsxfsvrl")
    public suspend fun claims(`value`: List<TokenClaimArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claims = mapped
    }

    /**
     * @param argument List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("cefkwdwmyjuueboc")
    public suspend fun claims(argument: List<suspend TokenClaimArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TokenClaimArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param argument List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("elvkyyxwfvxjqaff")
    public suspend fun claims(vararg argument: suspend TokenClaimArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TokenClaimArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param argument List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("ufqmuwwtghsbyfxf")
    public suspend fun claims(argument: suspend TokenClaimArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TokenClaimArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param values List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
     */
    @JvmName("fkwumrihhacwrxnn")
    public suspend fun claims(vararg values: TokenClaimArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.claims = mapped
    }

    /**
     * @param value List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
     */
    @JvmName("isvgpkitwqyqvokk")
    public suspend fun issuers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuers = mapped
    }

    /**
     * @param values List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
     */
    @JvmName("glaqrmasixpmxxhr")
    public suspend fun issuers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuers = mapped
    }

    /**
     * @param value List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
     */
    @JvmName("rdkpuucbrxjvtjow")
    public suspend fun keys(`value`: List<Either<EccTokenKeyArgs, RsaTokenKeyArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param values List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
     */
    @JvmName("hwdpfxogcsvmuhhh")
    public suspend fun keys(vararg values: Either<EccTokenKeyArgs, RsaTokenKeyArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
     */
    @JvmName("nppxsvpwbnnrmbfr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JwtAuthenticationArgs = JwtAuthenticationArgs(
        audiences = audiences,
        claims = claims,
        issuers = issuers,
        keys = keys,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
