@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.NetworkAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Network access control for video analyzer account.
 * @property consumption Public network access for consumption group.
 * @property ingestion Public network access for ingestion group.
 * @property integration Public network access for integration group.
 */
public data class NetworkAccessControlArgs(
    public val consumption: Output<GroupLevelAccessControlArgs>? = null,
    public val ingestion: Output<GroupLevelAccessControlArgs>? = null,
    public val integration: Output<GroupLevelAccessControlArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.NetworkAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.NetworkAccessControlArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.NetworkAccessControlArgs.builder()
            .consumption(consumption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ingestion(ingestion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integration(integration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NetworkAccessControlArgs].
 */
@PulumiTagMarker
public class NetworkAccessControlArgsBuilder internal constructor() {
    private var consumption: Output<GroupLevelAccessControlArgs>? = null

    private var ingestion: Output<GroupLevelAccessControlArgs>? = null

    private var integration: Output<GroupLevelAccessControlArgs>? = null

    /**
     * @param value Public network access for consumption group.
     */
    @JvmName("byfstjswukvbtljo")
    public suspend fun consumption(`value`: Output<GroupLevelAccessControlArgs>) {
        this.consumption = value
    }

    /**
     * @param value Public network access for ingestion group.
     */
    @JvmName("dbufybbrqfhyjsro")
    public suspend fun ingestion(`value`: Output<GroupLevelAccessControlArgs>) {
        this.ingestion = value
    }

    /**
     * @param value Public network access for integration group.
     */
    @JvmName("pvurkeedlanxovew")
    public suspend fun integration(`value`: Output<GroupLevelAccessControlArgs>) {
        this.integration = value
    }

    /**
     * @param value Public network access for consumption group.
     */
    @JvmName("cymgmwvjwsifxigc")
    public suspend fun consumption(`value`: GroupLevelAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumption = mapped
    }

    /**
     * @param argument Public network access for consumption group.
     */
    @JvmName("icuenutgkurqrxqn")
    public suspend fun consumption(argument: suspend GroupLevelAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = GroupLevelAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.consumption = mapped
    }

    /**
     * @param value Public network access for ingestion group.
     */
    @JvmName("mblmjrvvxdhashxa")
    public suspend fun ingestion(`value`: GroupLevelAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestion = mapped
    }

    /**
     * @param argument Public network access for ingestion group.
     */
    @JvmName("akbmufuxvcrudkdb")
    public suspend fun ingestion(argument: suspend GroupLevelAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = GroupLevelAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingestion = mapped
    }

    /**
     * @param value Public network access for integration group.
     */
    @JvmName("ubdtudwminvptisk")
    public suspend fun integration(`value`: GroupLevelAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integration = mapped
    }

    /**
     * @param argument Public network access for integration group.
     */
    @JvmName("dqeahdqadjmygmtc")
    public suspend fun integration(argument: suspend GroupLevelAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = GroupLevelAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integration = mapped
    }

    internal fun build(): NetworkAccessControlArgs = NetworkAccessControlArgs(
        consumption = consumption,
        ingestion = ingestion,
        integration = integration,
    )
}
