@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.ResourceIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The user assigned managed identity to use when accessing a resource.
 * @property userAssignedIdentity The user assigned managed identity's resource identifier to use when accessing a resource.
 */
public data class ResourceIdentityArgs(
    public val userAssignedIdentity: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.ResourceIdentityArgs.builder()
            .userAssignedIdentity(userAssignedIdentity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The user assigned managed identity's resource identifier to use when accessing a resource.
     */
    @JvmName("usgilyphviqxftir")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The user assigned managed identity's resource identifier to use when accessing a resource.
     */
    @JvmName("sdmmtqyhpshrqrsq")
    public suspend fun userAssignedIdentity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        userAssignedIdentity = userAssignedIdentity ?: throw
            PulumiNullFieldException("userAssignedIdentity"),
    )
}
