@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Required validation properties for tokens generated with Elliptical Curve algorithm.
 * @property alg Elliptical curve algorithm to be used: ES256, ES384 or ES512.
 * @property kid JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
 * @property x X coordinate.
 * @property y Y coordinate.
 */
public data class EccTokenKeyResponse(
    public val alg: String,
    public val kid: String,
    public val type: String,
    public val x: String,
    public val y: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.EccTokenKeyResponse):
            EccTokenKeyResponse = EccTokenKeyResponse(
            alg = javaType.alg(),
            kid = javaType.kid(),
            type = javaType.type(),
            x = javaType.x(),
            y = javaType.y(),
        )
    }
}
