@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Encoder processor allows for encoding of the input content. For example, it can used to change the resolution from 4K to 1280x720.
 * @property inputs An array of upstream node references within the topology to be used as inputs for this node.
 * @property name Node name. Must be unique within the topology.
 * @property preset The encoder preset, which defines the recipe or instructions on how the input content should be processed.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
 */
public data class EncoderProcessorResponse(
    public val inputs: List<NodeInputResponse>,
    public val name: String,
    public val preset: Either<EncoderCustomPresetResponse, EncoderSystemPresetResponse>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.EncoderProcessorResponse):
            EncoderProcessorResponse = EncoderProcessorResponse(
            inputs = javaType.inputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.NodeInputResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            preset = javaType.preset().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EncoderCustomPresetResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EncoderSystemPresetResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            type = javaType.type(),
        )
    }
}
