@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Video Analyzer account.
 * @property encryption The account encryption properties.
 * @property endpoints The endpoints associated with this resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identities associated to the Video Analyzer resource.
 * @property iotHubs The IoT Hubs for this resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkAccessControl Network access control for Video Analyzer.
 * @property privateEndpointConnections Private Endpoint Connections created under Video Analyzer account.
 * @property provisioningState Provisioning state of the Video Analyzer account.
 * @property publicNetworkAccess Whether or not public network access is allowed for resources under the Video Analyzer account.
 * @property storageAccounts The storage accounts for this resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVideoAnalyzerResult(
    public val encryption: AccountEncryptionResponse? = null,
    public val endpoints: List<EndpointResponse>,
    public val id: String,
    public val identity: VideoAnalyzerIdentityResponse? = null,
    public val iotHubs: List<IotHubResponse>? = null,
    public val location: String,
    public val name: String,
    public val networkAccessControl: NetworkAccessControlResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val storageAccounts: List<StorageAccountResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.GetVideoAnalyzerResult):
            GetVideoAnalyzerResult = GetVideoAnalyzerResult(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.AccountEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EndpointResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoAnalyzerIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            iotHubs = javaType.iotHubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.IotHubResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            networkAccessControl = javaType.networkAccessControl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.NetworkAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            storageAccounts = javaType.storageAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.StorageAccountResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
