@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a video resource within Azure Video Analyzer. Videos can be ingested from RTSP cameras through live pipelines or can be created by exporting sequences from existing captured video through a pipeline job. Videos ingested through live pipelines can be streamed through Azure Video Analyzer Player Widget or compatible players. Exported videos can be downloaded as MP4 files.
 * @property archival Video archival properties.
 * @property contentUrls Set of URLs to the video content.
 * @property description Optional video description provided by the user. Value can be up to 2048 characters long.
 * @property flags Video flags contain information about the available video actions and its dynamic properties based on the current video state.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property mediaInfo Contains information about the video and audio content.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property title Optional video title provided by the user. Value can be up to 256 characters long.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVideoResult(
    public val archival: VideoArchivalResponse? = null,
    public val contentUrls: VideoContentUrlsResponse,
    public val description: String? = null,
    public val flags: VideoFlagsResponse,
    public val id: String,
    public val mediaInfo: VideoMediaInfoResponse? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val title: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.GetVideoResult):
            GetVideoResult = GetVideoResult(
            archival = javaType.archival().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoArchivalResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentUrls = javaType.contentUrls().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoContentUrlsResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            flags = javaType.flags().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoFlagsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            mediaInfo = javaType.mediaInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoMediaInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
