@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Video archival properties.
 * @property retentionPeriod Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
 */
public data class VideoArchivalResponse(
    public val retentionPeriod: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoArchivalResponse):
            VideoArchivalResponse = VideoArchivalResponse(
            retentionPeriod = javaType.retentionPeriod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
