@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information about the video and audio content.
 * @property segmentLength Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
 */
public data class VideoMediaInfoResponse(
    public val segmentLength: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoMediaInfoResponse):
            VideoMediaInfoResponse = VideoMediaInfoResponse(
            segmentLength = javaType.segmentLength().map({ args0 -> args0 }).orElse(null),
        )
    }
}
