@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerLatestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Generates version number that will be latest based on existing version numbers.
 * @property major Major version for the generated version number. Determine what is "latest" based on versions with this value as the major version. -1 is equivalent to leaving it unset.
 * @property scheme Version numbering scheme to be used.
 * Expected value is 'Latest'.
 */
public data class DistributeVersionerLatestArgs(
    public val major: Output<Int>? = null,
    public val scheme: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerLatestArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerLatestArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerLatestArgs.builder()
            .major(major?.applyValue({ args0 -> args0 }))
            .scheme(scheme.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributeVersionerLatestArgs].
 */
@PulumiTagMarker
public class DistributeVersionerLatestArgsBuilder internal constructor() {
    private var major: Output<Int>? = null

    private var scheme: Output<String>? = null

    /**
     * @param value Major version for the generated version number. Determine what is "latest" based on versions with this value as the major version. -1 is equivalent to leaving it unset.
     */
    @JvmName("pjjludqrsycicljx")
    public suspend fun major(`value`: Output<Int>) {
        this.major = value
    }

    /**
     * @param value Version numbering scheme to be used.
     * Expected value is 'Latest'.
     */
    @JvmName("xeqptmprbjnidaxq")
    public suspend fun scheme(`value`: Output<String>) {
        this.scheme = value
    }

    /**
     * @param value Major version for the generated version number. Determine what is "latest" based on versions with this value as the major version. -1 is equivalent to leaving it unset.
     */
    @JvmName("cbdcmxvqapoklvmx")
    public suspend fun major(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.major = mapped
    }

    /**
     * @param value Version numbering scheme to be used.
     * Expected value is 'Latest'.
     */
    @JvmName("spqboukxayhilogx")
    public suspend fun scheme(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): DistributeVersionerLatestArgs = DistributeVersionerLatestArgs(
        major = major,
        scheme = scheme ?: throw PulumiNullFieldException("scheme"),
    )
}
