@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.GetVirtualMachineImageTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageTemplateName The name of the image Template
 * @property resourceGroupName The name of the resource group.
 */
public data class GetVirtualMachineImageTemplatePlainArgs(
    public val imageTemplateName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.GetVirtualMachineImageTemplatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.GetVirtualMachineImageTemplatePlainArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.GetVirtualMachineImageTemplatePlainArgs.builder()
            .imageTemplateName(imageTemplateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineImageTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineImageTemplatePlainArgsBuilder internal constructor() {
    private var imageTemplateName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the image Template
     */
    @JvmName("thjnljibvaiyxcpf")
    public suspend fun imageTemplateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.imageTemplateName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("djuuwdonptwurnhc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetVirtualMachineImageTemplatePlainArgs =
        GetVirtualMachineImageTemplatePlainArgs(
            imageTemplateName = imageTemplateName ?: throw PulumiNullFieldException("imageTemplateName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
