@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePowerShellValidatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Runs the specified PowerShell script during the validation phase (Windows). Corresponds to Packer powershell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
 * @property inline Array of PowerShell commands to execute
 * @property name Friendly Name to provide context on what this validation step does
 * @property runAsSystem If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true when the runElevated field above is set to true.
 * @property runElevated If specified, the PowerShell script will be run with elevated privileges
 * @property scriptUri URI of the PowerShell script to be run for validation. It can be a github link, Azure Storage URI, etc
 * @property sha256Checksum SHA256 checksum of the power shell script provided in the scriptUri field above
 * @property type The type of validation you want to use on the Image. For example, "Shell" can be shell validation
 * Expected value is 'PowerShell'.
 * @property validExitCodes Valid exit codes for the PowerShell script. [Default: 0]
 */
public data class ImageTemplatePowerShellValidatorArgs(
    public val `inline`: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val runAsSystem: Output<Boolean>? = null,
    public val runElevated: Output<Boolean>? = null,
    public val scriptUri: Output<String>? = null,
    public val sha256Checksum: Output<String>? = null,
    public val type: Output<String>,
    public val validExitCodes: Output<List<Int>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePowerShellValidatorArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePowerShellValidatorArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePowerShellValidatorArgs.builder()
            .`inline`(`inline`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .runAsSystem(runAsSystem?.applyValue({ args0 -> args0 }))
            .runElevated(runElevated?.applyValue({ args0 -> args0 }))
            .scriptUri(scriptUri?.applyValue({ args0 -> args0 }))
            .sha256Checksum(sha256Checksum?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .validExitCodes(validExitCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ImageTemplatePowerShellValidatorArgs].
 */
@PulumiTagMarker
public class ImageTemplatePowerShellValidatorArgsBuilder internal constructor() {
    private var `inline`: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var runAsSystem: Output<Boolean>? = null

    private var runElevated: Output<Boolean>? = null

    private var scriptUri: Output<String>? = null

    private var sha256Checksum: Output<String>? = null

    private var type: Output<String>? = null

    private var validExitCodes: Output<List<Int>>? = null

    /**
     * @param value Array of PowerShell commands to execute
     */
    @JvmName("sumpolycsijrdtcg")
    public suspend fun `inline`(`value`: Output<List<String>>) {
        this.`inline` = value
    }

    @JvmName("fyawtsyojwslomhw")
    public suspend fun `inline`(vararg values: Output<String>) {
        this.`inline` = Output.all(values.asList())
    }

    /**
     * @param values Array of PowerShell commands to execute
     */
    @JvmName("hskmmpuxvwygmpyq")
    public suspend fun `inline`(values: List<Output<String>>) {
        this.`inline` = Output.all(values)
    }

    /**
     * @param value Friendly Name to provide context on what this validation step does
     */
    @JvmName("egepoaqjgurrpiiu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true when the runElevated field above is set to true.
     */
    @JvmName("ayegmxnbgwkwnngk")
    public suspend fun runAsSystem(`value`: Output<Boolean>) {
        this.runAsSystem = value
    }

    /**
     * @param value If specified, the PowerShell script will be run with elevated privileges
     */
    @JvmName("vvrxfcgetsyvpvtw")
    public suspend fun runElevated(`value`: Output<Boolean>) {
        this.runElevated = value
    }

    /**
     * @param value URI of the PowerShell script to be run for validation. It can be a github link, Azure Storage URI, etc
     */
    @JvmName("mskmqjmhokiuendd")
    public suspend fun scriptUri(`value`: Output<String>) {
        this.scriptUri = value
    }

    /**
     * @param value SHA256 checksum of the power shell script provided in the scriptUri field above
     */
    @JvmName("mciywrxdxvpgrukc")
    public suspend fun sha256Checksum(`value`: Output<String>) {
        this.sha256Checksum = value
    }

    /**
     * @param value The type of validation you want to use on the Image. For example, "Shell" can be shell validation
     * Expected value is 'PowerShell'.
     */
    @JvmName("qpihlethuwxoubii")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Valid exit codes for the PowerShell script. [Default: 0]
     */
    @JvmName("ojcbqgxmqxijeyxa")
    public suspend fun validExitCodes(`value`: Output<List<Int>>) {
        this.validExitCodes = value
    }

    @JvmName("ggdvathafisktygk")
    public suspend fun validExitCodes(vararg values: Output<Int>) {
        this.validExitCodes = Output.all(values.asList())
    }

    /**
     * @param values Valid exit codes for the PowerShell script. [Default: 0]
     */
    @JvmName("xlvdjdejxhobjdww")
    public suspend fun validExitCodes(values: List<Output<Int>>) {
        this.validExitCodes = Output.all(values)
    }

    /**
     * @param value Array of PowerShell commands to execute
     */
    @JvmName("fjwtsibxjyohhgrn")
    public suspend fun `inline`(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`inline` = mapped
    }

    /**
     * @param values Array of PowerShell commands to execute
     */
    @JvmName("vatabkhibbmcyvdc")
    public suspend fun `inline`(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`inline` = mapped
    }

    /**
     * @param value Friendly Name to provide context on what this validation step does
     */
    @JvmName("sxgsbtunpulcadiu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true when the runElevated field above is set to true.
     */
    @JvmName("jelkjaohxvxlmdgo")
    public suspend fun runAsSystem(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsSystem = mapped
    }

    /**
     * @param value If specified, the PowerShell script will be run with elevated privileges
     */
    @JvmName("netuoqsmnkvqqyau")
    public suspend fun runElevated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runElevated = mapped
    }

    /**
     * @param value URI of the PowerShell script to be run for validation. It can be a github link, Azure Storage URI, etc
     */
    @JvmName("kxxyichevyewvutb")
    public suspend fun scriptUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUri = mapped
    }

    /**
     * @param value SHA256 checksum of the power shell script provided in the scriptUri field above
     */
    @JvmName("kcypmexjjkniewhq")
    public suspend fun sha256Checksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sha256Checksum = mapped
    }

    /**
     * @param value The type of validation you want to use on the Image. For example, "Shell" can be shell validation
     * Expected value is 'PowerShell'.
     */
    @JvmName("ofuqxnffbmpotbwj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Valid exit codes for the PowerShell script. [Default: 0]
     */
    @JvmName("ivjbnlfcqhjkoiwo")
    public suspend fun validExitCodes(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validExitCodes = mapped
    }

    /**
     * @param values Valid exit codes for the PowerShell script. [Default: 0]
     */
    @JvmName("xljbvsgeosyuapwl")
    public suspend fun validExitCodes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validExitCodes = mapped
    }

    internal fun build(): ImageTemplatePowerShellValidatorArgs = ImageTemplatePowerShellValidatorArgs(
        `inline` = `inline`,
        name = name,
        runAsSystem = runAsSystem,
        runElevated = runElevated,
        scriptUri = scriptUri,
        sha256Checksum = sha256Checksum,
        type = type ?: throw PulumiNullFieldException("type"),
        validExitCodes = validExitCodes,
    )
}
