@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Generates version number that will be latest based on existing version numbers.
 * @property major Major version for the generated version number. Determine what is "latest" based on versions with this value as the major version. -1 is equivalent to leaving it unset.
 * @property scheme Version numbering scheme to be used.
 * Expected value is 'Latest'.
 */
public data class DistributeVersionerLatestResponse(
    public val major: Int? = null,
    public val scheme: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.DistributeVersionerLatestResponse):
            DistributeVersionerLatestResponse = DistributeVersionerLatestResponse(
            major = javaType.major().map({ args0 -> args0 }).orElse(null),
            scheme = javaType.scheme(),
        )
    }
}
