@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the latest status of running an image template
 * @property endTime End time of the last run (UTC)
 * @property message Verbose information about the last run state
 * @property runState State of the last run
 * @property runSubState Sub-state of the last run
 * @property startTime Start time of the last run (UTC)
 */
public data class ImageTemplateLastRunStatusResponse(
    public val endTime: String? = null,
    public val message: String? = null,
    public val runState: String? = null,
    public val runSubState: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateLastRunStatusResponse):
            ImageTemplateLastRunStatusResponse = ImageTemplateLastRunStatusResponse(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            runState = javaType.runState().map({ args0 -> args0 }).orElse(null),
            runSubState = javaType.runSubState().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
