@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual Network configuration.
 * @property proxyVmSize Size of the proxy virtual machine used to pass traffic to the build VM and validation VM. Omit or specify empty string to use the default (Standard_A1_v2).
 * @property subnetId Resource id of a pre-existing subnet.
 */
public data class VirtualNetworkConfigResponse(
    public val proxyVmSize: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.VirtualNetworkConfigResponse):
            VirtualNetworkConfigResponse = VirtualNetworkConfigResponse(
            proxyVmSize = javaType.proxyVmSize().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
