@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin

import com.pulumi.azurenative.visualstudio.VisualstudioFunctions.getAccountPlain
import com.pulumi.azurenative.visualstudio.VisualstudioFunctions.getExtensionPlain
import com.pulumi.azurenative.visualstudio.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.visualstudio.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.visualstudio.kotlin.inputs.GetExtensionPlainArgs
import com.pulumi.azurenative.visualstudio.kotlin.inputs.GetExtensionPlainArgsBuilder
import com.pulumi.azurenative.visualstudio.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.visualstudio.kotlin.outputs.GetExtensionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.visualstudio.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.visualstudio.kotlin.outputs.GetExtensionResult.Companion.toKotlin as getExtensionResultToKotlin

public object VisualstudioFunctions {
    /**
     * Gets the Visual Studio Team Services account resource details.
     * Azure REST API version: 2017-11-01-preview.
     * @param argument null
     * @return The response to an account resource GET request.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param resourceGroupName Name of the resource group within the Azure subscription.
     * @param resourceName Name of the resource.
     * @return The response to an account resource GET request.
     */
    public suspend fun getAccount(resourceGroupName: String, resourceName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;visualstudio&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return The response to an account resource GET request.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of an extension associated with a Visual Studio Team Services account resource.
     * Azure REST API version: 2017-11-01-preview.
     * @param argument null
     * @return The response to an extension resource GET request.
     */
    public suspend fun getExtension(argument: GetExtensionPlainArgs): GetExtensionResult =
        getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())

    /**
     * @see [getExtension].
     * @param accountResourceName The name of the Visual Studio Team Services account resource.
     * @param extensionResourceName The name of the extension.
     * @param resourceGroupName Name of the resource group within the Azure subscription.
     * @return The response to an extension resource GET request.
     */
    public suspend fun getExtension(
        accountResourceName: String,
        extensionResourceName: String,
        resourceGroupName: String,
    ): GetExtensionResult {
        val argument = GetExtensionPlainArgs(
            accountResourceName = accountResourceName,
            extensionResourceName = extensionResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;visualstudio&#46;kotlin&#46;inputs&#46;GetExtensionPlainArgs].
     * @return The response to an extension resource GET request.
     */
    public suspend fun getExtension(argument: suspend GetExtensionPlainArgsBuilder.() -> Unit):
        GetExtensionResult {
        val builder = GetExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtensionResultToKotlin(getExtensionPlain(builtArgument.toJava()).await())
    }
}
