@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNodeArgs.builder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dedicated cloud node model
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### CreateDedicatedCloudNode
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedCloudNode = new AzureNative.VMwareCloudSimple.DedicatedCloudNode("dedicatedCloudNode", new()
 *     {
 *         AvailabilityZoneId = "az1",
 *         DedicatedCloudNodeName = "myNode",
 *         Id = "general",
 *         Location = "westus",
 *         Name = "CS28-Node",
 *         NodesCount = 1,
 *         PlacementGroupId = "n1",
 *         PurchaseId = "56acbd46-3d36-4bbf-9b08-57c30fdf6932",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.VMwareCloudSimple.Inputs.SkuArgs
 *         {
 *             Name = "VMware_CloudSimple_CS28",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/vmwarecloudsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vmwarecloudsimple.NewDedicatedCloudNode(ctx, "dedicatedCloudNode", &vmwarecloudsimple.DedicatedCloudNodeArgs{
 * 			AvailabilityZoneId:     pulumi.String("az1"),
 * 			DedicatedCloudNodeName: pulumi.String("myNode"),
 * 			Id:                     pulumi.String("general"),
 * 			Location:               pulumi.String("westus"),
 * 			Name:                   pulumi.String("CS28-Node"),
 * 			NodesCount:             pulumi.Int(1),
 * 			PlacementGroupId:       pulumi.String("n1"),
 * 			PurchaseId:             pulumi.String("56acbd46-3d36-4bbf-9b08-57c30fdf6932"),
 * 			ResourceGroupName:      pulumi.String("myResourceGroup"),
 * 			Sku: &vmwarecloudsimple.SkuArgs{
 * 				Name: pulumi.String("VMware_CloudSimple_CS28"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNode;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNodeArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedCloudNode = new DedicatedCloudNode("dedicatedCloudNode", DedicatedCloudNodeArgs.builder()
 *             .availabilityZoneId("az1")
 *             .dedicatedCloudNodeName("myNode")
 *             .id("general")
 *             .location("westus")
 *             .name("CS28-Node")
 *             .nodesCount(1)
 *             .placementGroupId("n1")
 *             .purchaseId("56acbd46-3d36-4bbf-9b08-57c30fdf6932")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("VMware_CloudSimple_CS28")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:vmwarecloudsimple:DedicatedCloudNode myNode /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VMwareCloudSimple/dedicatedCloudNodes/{dedicatedCloudNodeName}
 * ```
 * @property availabilityZoneId Availability Zone id, e.g. "az1"
 * @property dedicatedCloudNodeName dedicated cloud node name
 * @property id SKU's id
 * @property location Azure region
 * @property name SKU's name
 * @property nodesCount count of nodes to create
 * @property placementGroupId Placement Group id, e.g. "n1"
 * @property purchaseId purchase id
 * @property resourceGroupName The name of the resource group
 * @property sku Dedicated Cloud Nodes SKU
 * @property tags Dedicated Cloud Nodes tags
 */
public data class DedicatedCloudNodeArgs(
    public val availabilityZoneId: Output<String>? = null,
    public val dedicatedCloudNodeName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nodesCount: Output<Int>? = null,
    public val placementGroupId: Output<String>? = null,
    public val purchaseId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNodeArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNodeArgs =
        com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudNodeArgs.builder()
            .availabilityZoneId(availabilityZoneId?.applyValue({ args0 -> args0 }))
            .dedicatedCloudNodeName(dedicatedCloudNodeName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nodesCount(nodesCount?.applyValue({ args0 -> args0 }))
            .placementGroupId(placementGroupId?.applyValue({ args0 -> args0 }))
            .purchaseId(purchaseId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DedicatedCloudNodeArgs].
 */
@PulumiTagMarker
public class DedicatedCloudNodeArgsBuilder internal constructor() {
    private var availabilityZoneId: Output<String>? = null

    private var dedicatedCloudNodeName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var nodesCount: Output<Int>? = null

    private var placementGroupId: Output<String>? = null

    private var purchaseId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Availability Zone id, e.g. "az1"
     */
    @JvmName("tsycbglrmpqwlber")
    public suspend fun availabilityZoneId(`value`: Output<String>) {
        this.availabilityZoneId = value
    }

    /**
     * @param value dedicated cloud node name
     */
    @JvmName("qmfpckjlcxswyxxj")
    public suspend fun dedicatedCloudNodeName(`value`: Output<String>) {
        this.dedicatedCloudNodeName = value
    }

    /**
     * @param value SKU's id
     */
    @JvmName("eunwvkbghgswhycu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure region
     */
    @JvmName("hhdxwdgmmkfldyqf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value SKU's name
     */
    @JvmName("ldlddukcvodrescl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value count of nodes to create
     */
    @JvmName("ljeyqwlgvwalrqtg")
    public suspend fun nodesCount(`value`: Output<Int>) {
        this.nodesCount = value
    }

    /**
     * @param value Placement Group id, e.g. "n1"
     */
    @JvmName("fglluaflsnlcguie")
    public suspend fun placementGroupId(`value`: Output<String>) {
        this.placementGroupId = value
    }

    /**
     * @param value purchase id
     */
    @JvmName("rhswjwqffnxpcevn")
    public suspend fun purchaseId(`value`: Output<String>) {
        this.purchaseId = value
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("typjrhqygvbqcxme")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Dedicated Cloud Nodes SKU
     */
    @JvmName("dqjoqaxbdpopkrdx")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Dedicated Cloud Nodes tags
     */
    @JvmName("pdpewfkrsdgfahak")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Availability Zone id, e.g. "az1"
     */
    @JvmName("ooucmmjnjiymrnqb")
    public suspend fun availabilityZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneId = mapped
    }

    /**
     * @param value dedicated cloud node name
     */
    @JvmName("sstmeujljxeivfqi")
    public suspend fun dedicatedCloudNodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedCloudNodeName = mapped
    }

    /**
     * @param value SKU's id
     */
    @JvmName("uyjxrryhqosuxndd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Azure region
     */
    @JvmName("pvdmrriqlletjbnp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value SKU's name
     */
    @JvmName("lhiibijdiypfoqeo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value count of nodes to create
     */
    @JvmName("cspfkrqwpbvejngs")
    public suspend fun nodesCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodesCount = mapped
    }

    /**
     * @param value Placement Group id, e.g. "n1"
     */
    @JvmName("pnobdxbogbsycpdm")
    public suspend fun placementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroupId = mapped
    }

    /**
     * @param value purchase id
     */
    @JvmName("hstmxaqlxxmbqtlj")
    public suspend fun purchaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purchaseId = mapped
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("gfqyttaremrkkpna")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Dedicated Cloud Nodes SKU
     */
    @JvmName("cmlwjahjjgvyiybb")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Dedicated Cloud Nodes SKU
     */
    @JvmName("aplnnhumwgegifea")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Dedicated Cloud Nodes tags
     */
    @JvmName("ycpgdfphjeosbmwc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Dedicated Cloud Nodes tags
     */
    @JvmName("krawdfwhvuobbrch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DedicatedCloudNodeArgs = DedicatedCloudNodeArgs(
        availabilityZoneId = availabilityZoneId,
        dedicatedCloudNodeName = dedicatedCloudNodeName,
        id = id,
        location = location,
        name = name,
        nodesCount = nodesCount,
        placementGroupId = placementGroupId,
        purchaseId = purchaseId,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
