@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GuestOSCustomizationResponse
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.ResourcePoolResponse
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualDiskControllerResponse
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualDiskResponse
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualNicResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GuestOSCustomizationResponse.Companion.toKotlin as guestOSCustomizationResponseToKotlin
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.ResourcePoolResponse.Companion.toKotlin as resourcePoolResponseToKotlin
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualDiskControllerResponse.Companion.toKotlin as virtualDiskControllerResponseToKotlin
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin as virtualDiskResponseToKotlin
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualNicResponse.Companion.toKotlin as virtualNicResponseToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.vmwarecloudsimple.VirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 * Virtual machine model
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.VMwareCloudSimple.VirtualMachine("virtualMachine", new()
 *     {
 *         AmountOfRam = 4096,
 *         Disks = new[]
 *         {
 *             new AzureNative.VMwareCloudSimple.Inputs.VirtualDiskArgs
 *             {
 *                 ControllerId = "1000",
 *                 IndependenceMode = AzureNative.VMwareCloudSimple.DiskIndependenceMode.Persistent,
 *                 TotalSize = 10485760,
 *                 VirtualDiskId = "2000",
 *             },
 *         },
 *         Location = "westus2",
 *         Nics = new[]
 *         {
 *             new AzureNative.VMwareCloudSimple.Inputs.VirtualNicArgs
 *             {
 *                 Network = new AzureNative.VMwareCloudSimple.Inputs.VirtualNetworkArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualNetworks/dvportgroup-19",
 *                 },
 *                 NicType = AzureNative.VMwareCloudSimple.NICType.E1000,
 *                 PowerOnBoot = true,
 *                 VirtualNicId = "4000",
 *             },
 *         },
 *         NumberOfCores = 2,
 *         PrivateCloudId = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourcePool = new AzureNative.VMwareCloudSimple.Inputs.ResourcePoolArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/resourcePools/resgroup-26",
 *         },
 *         TemplateId = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualMachineTemplates/vm-34",
 *         VirtualMachineName = "myVirtualMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/vmwarecloudsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vmwarecloudsimple.NewVirtualMachine(ctx, "virtualMachine", &vmwarecloudsimple.VirtualMachineArgs{
 * 			AmountOfRam: pulumi.Int(4096),
 * 			Disks: vmwarecloudsimple.VirtualDiskArray{
 * 				&vmwarecloudsimple.VirtualDiskArgs{
 * 					ControllerId:     pulumi.String("1000"),
 * 					IndependenceMode: vmwarecloudsimple.DiskIndependenceModePersistent,
 * 					TotalSize:        pulumi.Int(10485760),
 * 					VirtualDiskId:    pulumi.String("2000"),
 * 				},
 * 			},
 * 			Location: pulumi.String("westus2"),
 * 			Nics: vmwarecloudsimple.VirtualNicArray{
 * 				&vmwarecloudsimple.VirtualNicArgs{
 * 					Network: &vmwarecloudsimple.VirtualNetworkArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualNetworks/dvportgroup-19"),
 * 					},
 * 					NicType:      vmwarecloudsimple.NICTypeE1000,
 * 					PowerOnBoot:  pulumi.Bool(true),
 * 					VirtualNicId: pulumi.String("4000"),
 * 				},
 * 			},
 * 			NumberOfCores:     pulumi.Int(2),
 * 			PrivateCloudId:    pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourcePool: &vmwarecloudsimple.ResourcePoolArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/resourcePools/resgroup-26"),
 * 			},
 * 			TemplateId:         pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualMachineTemplates/vm-34"),
 * 			VirtualMachineName: pulumi.String("myVirtualMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.vmwarecloudsimple.VirtualMachine;
 * import com.pulumi.azurenative.vmwarecloudsimple.VirtualMachineArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualDiskArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNicArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNetworkArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.ResourcePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .amountOfRam(4096)
 *             .disks(VirtualDiskArgs.builder()
 *                 .controllerId("1000")
 *                 .independenceMode("persistent")
 *                 .totalSize(10485760)
 *                 .virtualDiskId("2000")
 *                 .build())
 *             .location("westus2")
 *             .nics(VirtualNicArgs.builder()
 *                 .network(VirtualNetworkArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualNetworks/dvportgroup-19")
 *                     .build())
 *                 .nicType("E1000")
 *                 .powerOnBoot(true)
 *                 .virtualNicId("4000")
 *                 .build())
 *             .numberOfCores(2)
 *             .privateCloudId("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud")
 *             .resourceGroupName("myResourceGroup")
 *             .resourcePool(ResourcePoolArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/resourcePools/resgroup-26")
 *                 .build())
 *             .templateId("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualMachineTemplates/vm-34")
 *             .virtualMachineName("myVirtualMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:vmwarecloudsimple:VirtualMachine myVirtualMachine /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VMwareCloudSimple/virtualMachines/{virtualMachineName}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.vmwarecloudsimple.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * The amount of memory
     */
    public val amountOfRam: Output<Int>
        get() = javaResource.amountOfRam().applyValue({ args0 -> args0 })

    /**
     * The list of Virtual Disks' Controllers
     */
    public val controllers: Output<List<VirtualDiskControllerResponse>>
        get() = javaResource.controllers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualDiskControllerResponseToKotlin(args0)
                })
            })
        })

    /**
     * Virtual machine properties
     */
    public val customization: Output<GuestOSCustomizationResponse>?
        get() = javaResource.customization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> guestOSCustomizationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of Virtual Disks
     */
    public val disks: Output<List<VirtualDiskResponse>>?
        get() = javaResource.disks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> virtualDiskResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The DNS name of Virtual Machine in VCenter
     */
    public val dnsname: Output<String>
        get() = javaResource.dnsname().applyValue({ args0 -> args0 })

    /**
     * Expose Guest OS or not
     */
    public val exposeToGuestVM: Output<Boolean>?
        get() = javaResource.exposeToGuestVM().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path to virtual machine folder in VCenter
     */
    public val folder: Output<String>
        get() = javaResource.folder().applyValue({ args0 -> args0 })

    /**
     * The name of Guest OS
     */
    public val guestOS: Output<String>
        get() = javaResource.guestOS().applyValue({ args0 -> args0 })

    /**
     * The Guest OS type
     */
    public val guestOSType: Output<String>
        get() = javaResource.guestOSType().applyValue({ args0 -> args0 })

    /**
     * Azure region
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * {virtualMachineName}
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of Virtual NICs
     */
    public val nics: Output<List<VirtualNicResponse>>?
        get() = javaResource.nics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> virtualNicResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The number of CPU cores
     */
    public val numberOfCores: Output<Int>
        get() = javaResource.numberOfCores().applyValue({ args0 -> args0 })

    /**
     * Password for login. Deprecated - use customization property
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Private Cloud Id
     */
    public val privateCloudId: Output<String>
        get() = javaResource.privateCloudId().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The public ip of Virtual Machine
     */
    public val publicIP: Output<String>
        get() = javaResource.publicIP().applyValue({ args0 -> args0 })

    /**
     * Virtual Machines Resource Pool
     */
    public val resourcePool: Output<ResourcePoolResponse>?
        get() = javaResource.resourcePool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourcePoolResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of Virtual machine
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The list of tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Virtual Machine Template Id
     */
    public val templateId: Output<String>?
        get() = javaResource.templateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * {resourceProviderNamespace}/{resourceType}
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Username for login. Deprecated - use customization property
     */
    public val username: Output<String>?
        get() = javaResource.username().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of Virtual VSphere Networks
     */
    public val vSphereNetworks: Output<List<String>>?
        get() = javaResource.vSphereNetworks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The internal id of Virtual Machine in VCenter
     */
    public val vmId: Output<String>
        get() = javaResource.vmId().applyValue({ args0 -> args0 })

    /**
     * VMware tools version
     */
    public val vmwaretools: Output<String>
        get() = javaResource.vmwaretools().applyValue({ args0 -> args0 })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.vmwarecloudsimple.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.vmwarecloudsimple.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
