@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.azurenative.vmwarecloudsimple.VirtualMachineArgs.builder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GuestOSCustomizationArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GuestOSCustomizationArgsBuilder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.ResourcePoolArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.ResourcePoolArgsBuilder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.VirtualDiskArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.VirtualDiskArgsBuilder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.VirtualNicArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.VirtualNicArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Virtual machine model
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.VMwareCloudSimple.VirtualMachine("virtualMachine", new()
 *     {
 *         AmountOfRam = 4096,
 *         Disks = new[]
 *         {
 *             new AzureNative.VMwareCloudSimple.Inputs.VirtualDiskArgs
 *             {
 *                 ControllerId = "1000",
 *                 IndependenceMode = AzureNative.VMwareCloudSimple.DiskIndependenceMode.Persistent,
 *                 TotalSize = 10485760,
 *                 VirtualDiskId = "2000",
 *             },
 *         },
 *         Location = "westus2",
 *         Nics = new[]
 *         {
 *             new AzureNative.VMwareCloudSimple.Inputs.VirtualNicArgs
 *             {
 *                 Network = new AzureNative.VMwareCloudSimple.Inputs.VirtualNetworkArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualNetworks/dvportgroup-19",
 *                 },
 *                 NicType = AzureNative.VMwareCloudSimple.NICType.E1000,
 *                 PowerOnBoot = true,
 *                 VirtualNicId = "4000",
 *             },
 *         },
 *         NumberOfCores = 2,
 *         PrivateCloudId = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourcePool = new AzureNative.VMwareCloudSimple.Inputs.ResourcePoolArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/resourcePools/resgroup-26",
 *         },
 *         TemplateId = "/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualMachineTemplates/vm-34",
 *         VirtualMachineName = "myVirtualMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/vmwarecloudsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vmwarecloudsimple.NewVirtualMachine(ctx, "virtualMachine", &vmwarecloudsimple.VirtualMachineArgs{
 * 			AmountOfRam: pulumi.Int(4096),
 * 			Disks: vmwarecloudsimple.VirtualDiskArray{
 * 				&vmwarecloudsimple.VirtualDiskArgs{
 * 					ControllerId:     pulumi.String("1000"),
 * 					IndependenceMode: vmwarecloudsimple.DiskIndependenceModePersistent,
 * 					TotalSize:        pulumi.Int(10485760),
 * 					VirtualDiskId:    pulumi.String("2000"),
 * 				},
 * 			},
 * 			Location: pulumi.String("westus2"),
 * 			Nics: vmwarecloudsimple.VirtualNicArray{
 * 				&vmwarecloudsimple.VirtualNicArgs{
 * 					Network: &vmwarecloudsimple.VirtualNetworkArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualNetworks/dvportgroup-19"),
 * 					},
 * 					NicType:      vmwarecloudsimple.NICTypeE1000,
 * 					PowerOnBoot:  pulumi.Bool(true),
 * 					VirtualNicId: pulumi.String("4000"),
 * 				},
 * 			},
 * 			NumberOfCores:     pulumi.Int(2),
 * 			PrivateCloudId:    pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourcePool: &vmwarecloudsimple.ResourcePoolArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/resourcePools/resgroup-26"),
 * 			},
 * 			TemplateId:         pulumi.String("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualMachineTemplates/vm-34"),
 * 			VirtualMachineName: pulumi.String("myVirtualMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.vmwarecloudsimple.VirtualMachine;
 * import com.pulumi.azurenative.vmwarecloudsimple.VirtualMachineArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualDiskArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNicArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNetworkArgs;
 * import com.pulumi.azurenative.vmwarecloudsimple.inputs.ResourcePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .amountOfRam(4096)
 *             .disks(VirtualDiskArgs.builder()
 *                 .controllerId("1000")
 *                 .independenceMode("persistent")
 *                 .totalSize(10485760)
 *                 .virtualDiskId("2000")
 *                 .build())
 *             .location("westus2")
 *             .nics(VirtualNicArgs.builder()
 *                 .network(VirtualNetworkArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualNetworks/dvportgroup-19")
 *                     .build())
 *                 .nicType("E1000")
 *                 .powerOnBoot(true)
 *                 .virtualNicId("4000")
 *                 .build())
 *             .numberOfCores(2)
 *             .privateCloudId("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud")
 *             .resourceGroupName("myResourceGroup")
 *             .resourcePool(ResourcePoolArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/resourcePools/resgroup-26")
 *                 .build())
 *             .templateId("/subscriptions/{subscription-id}/providers/Microsoft.VMwareCloudSimple/locations/westus2/privateClouds/myPrivateCloud/virtualMachineTemplates/vm-34")
 *             .virtualMachineName("myVirtualMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:vmwarecloudsimple:VirtualMachine myVirtualMachine /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VMwareCloudSimple/virtualMachines/{virtualMachineName}
 * ```
 * @property amountOfRam The amount of memory
 * @property customization Virtual machine properties
 * @property disks The list of Virtual Disks
 * @property exposeToGuestVM Expose Guest OS or not
 * @property location Azure region
 * @property nics The list of Virtual NICs
 * @property numberOfCores The number of CPU cores
 * @property password Password for login. Deprecated - use customization property
 * @property privateCloudId Private Cloud Id
 * @property resourceGroupName The name of the resource group
 * @property resourcePool Virtual Machines Resource Pool
 * @property tags The list of tags
 * @property templateId Virtual Machine Template Id
 * @property username Username for login. Deprecated - use customization property
 * @property vSphereNetworks The list of Virtual VSphere Networks
 * @property virtualMachineName virtual machine name
 */
public data class VirtualMachineArgs(
    public val amountOfRam: Output<Int>? = null,
    public val customization: Output<GuestOSCustomizationArgs>? = null,
    public val disks: Output<List<VirtualDiskArgs>>? = null,
    public val exposeToGuestVM: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val nics: Output<List<VirtualNicArgs>>? = null,
    public val numberOfCores: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val privateCloudId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourcePool: Output<ResourcePoolArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateId: Output<String>? = null,
    public val username: Output<String>? = null,
    public val vSphereNetworks: Output<List<String>>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.VirtualMachineArgs =
        com.pulumi.azurenative.vmwarecloudsimple.VirtualMachineArgs.builder()
            .amountOfRam(amountOfRam?.applyValue({ args0 -> args0 }))
            .customization(customization?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disks(disks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .exposeToGuestVM(exposeToGuestVM?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .nics(nics?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .numberOfCores(numberOfCores?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .privateCloudId(privateCloudId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourcePool(resourcePool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 }))
            .vSphereNetworks(vSphereNetworks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var amountOfRam: Output<Int>? = null

    private var customization: Output<GuestOSCustomizationArgs>? = null

    private var disks: Output<List<VirtualDiskArgs>>? = null

    private var exposeToGuestVM: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var nics: Output<List<VirtualNicArgs>>? = null

    private var numberOfCores: Output<Int>? = null

    private var password: Output<String>? = null

    private var privateCloudId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourcePool: Output<ResourcePoolArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateId: Output<String>? = null

    private var username: Output<String>? = null

    private var vSphereNetworks: Output<List<String>>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value The amount of memory
     */
    @JvmName("snmwpaqaymfwrknh")
    public suspend fun amountOfRam(`value`: Output<Int>) {
        this.amountOfRam = value
    }

    /**
     * @param value Virtual machine properties
     */
    @JvmName("veyofpbmnavxplqd")
    public suspend fun customization(`value`: Output<GuestOSCustomizationArgs>) {
        this.customization = value
    }

    /**
     * @param value The list of Virtual Disks
     */
    @JvmName("syaldkumcscvmhee")
    public suspend fun disks(`value`: Output<List<VirtualDiskArgs>>) {
        this.disks = value
    }

    @JvmName("kbnbsolpkytesvaw")
    public suspend fun disks(vararg values: Output<VirtualDiskArgs>) {
        this.disks = Output.all(values.asList())
    }

    /**
     * @param values The list of Virtual Disks
     */
    @JvmName("kwwrkefaugngsfox")
    public suspend fun disks(values: List<Output<VirtualDiskArgs>>) {
        this.disks = Output.all(values)
    }

    /**
     * @param value Expose Guest OS or not
     */
    @JvmName("danrwtvakrwkuvpy")
    public suspend fun exposeToGuestVM(`value`: Output<Boolean>) {
        this.exposeToGuestVM = value
    }

    /**
     * @param value Azure region
     */
    @JvmName("ymygyjgqgbmfsuiy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The list of Virtual NICs
     */
    @JvmName("ieodjwhuwcgwypup")
    public suspend fun nics(`value`: Output<List<VirtualNicArgs>>) {
        this.nics = value
    }

    @JvmName("gyvvqefncgyfhukk")
    public suspend fun nics(vararg values: Output<VirtualNicArgs>) {
        this.nics = Output.all(values.asList())
    }

    /**
     * @param values The list of Virtual NICs
     */
    @JvmName("gtgtqulfkhsmhfjq")
    public suspend fun nics(values: List<Output<VirtualNicArgs>>) {
        this.nics = Output.all(values)
    }

    /**
     * @param value The number of CPU cores
     */
    @JvmName("prcytsbnkhfcjxvt")
    public suspend fun numberOfCores(`value`: Output<Int>) {
        this.numberOfCores = value
    }

    /**
     * @param value Password for login. Deprecated - use customization property
     */
    @JvmName("cwfgbggudghphctk")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Private Cloud Id
     */
    @JvmName("lshhsspmetuktodx")
    public suspend fun privateCloudId(`value`: Output<String>) {
        this.privateCloudId = value
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("btxrxljedhsiffje")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Virtual Machines Resource Pool
     */
    @JvmName("eodqjiplmkjmentd")
    public suspend fun resourcePool(`value`: Output<ResourcePoolArgs>) {
        this.resourcePool = value
    }

    /**
     * @param value The list of tags
     */
    @JvmName("gpepuugmkgpgoifl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Virtual Machine Template Id
     */
    @JvmName("vlhqodywrihfglwg")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Username for login. Deprecated - use customization property
     */
    @JvmName("qjuywcjogcrvwsla")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The list of Virtual VSphere Networks
     */
    @JvmName("nencgyrpqbshwvll")
    public suspend fun vSphereNetworks(`value`: Output<List<String>>) {
        this.vSphereNetworks = value
    }

    @JvmName("afakcnljdllcmiyy")
    public suspend fun vSphereNetworks(vararg values: Output<String>) {
        this.vSphereNetworks = Output.all(values.asList())
    }

    /**
     * @param values The list of Virtual VSphere Networks
     */
    @JvmName("gsthgrwppavewrbc")
    public suspend fun vSphereNetworks(values: List<Output<String>>) {
        this.vSphereNetworks = Output.all(values)
    }

    /**
     * @param value virtual machine name
     */
    @JvmName("gcmcsgiuciyqadba")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value The amount of memory
     */
    @JvmName("tkwmqkpwtqowcvqa")
    public suspend fun amountOfRam(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amountOfRam = mapped
    }

    /**
     * @param value Virtual machine properties
     */
    @JvmName("lnscelvgkytlabgu")
    public suspend fun customization(`value`: GuestOSCustomizationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customization = mapped
    }

    /**
     * @param argument Virtual machine properties
     */
    @JvmName("rtwhjtglvjxdelia")
    public suspend fun customization(argument: suspend GuestOSCustomizationArgsBuilder.() -> Unit) {
        val toBeMapped = GuestOSCustomizationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customization = mapped
    }

    /**
     * @param value The list of Virtual Disks
     */
    @JvmName("cftvejyyirwbmedp")
    public suspend fun disks(`value`: List<VirtualDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param argument The list of Virtual Disks
     */
    @JvmName("wkxfxenpjaimynpp")
    public suspend fun disks(argument: List<suspend VirtualDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VirtualDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument The list of Virtual Disks
     */
    @JvmName("jswcfuokdxorohib")
    public suspend fun disks(vararg argument: suspend VirtualDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VirtualDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument The list of Virtual Disks
     */
    @JvmName("dqxawkgxlcppwala")
    public suspend fun disks(argument: suspend VirtualDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param values The list of Virtual Disks
     */
    @JvmName("lbcaygjqcxraabli")
    public suspend fun disks(vararg values: VirtualDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param value Expose Guest OS or not
     */
    @JvmName("pcpbsrpelgvcnskk")
    public suspend fun exposeToGuestVM(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeToGuestVM = mapped
    }

    /**
     * @param value Azure region
     */
    @JvmName("xjhqsbkwhccgtvqs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The list of Virtual NICs
     */
    @JvmName("mqcdiififhuaocte")
    public suspend fun nics(`value`: List<VirtualNicArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nics = mapped
    }

    /**
     * @param argument The list of Virtual NICs
     */
    @JvmName("bycegwgbkvgesrno")
    public suspend fun nics(argument: List<suspend VirtualNicArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VirtualNicArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.nics = mapped
    }

    /**
     * @param argument The list of Virtual NICs
     */
    @JvmName("bbbnulqfsrsodplg")
    public suspend fun nics(vararg argument: suspend VirtualNicArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VirtualNicArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.nics = mapped
    }

    /**
     * @param argument The list of Virtual NICs
     */
    @JvmName("jgveesnatwuaogxu")
    public suspend fun nics(argument: suspend VirtualNicArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNicArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nics = mapped
    }

    /**
     * @param values The list of Virtual NICs
     */
    @JvmName("ijrtfwqilmuyahsa")
    public suspend fun nics(vararg values: VirtualNicArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nics = mapped
    }

    /**
     * @param value The number of CPU cores
     */
    @JvmName("mqcxjixwmokvstsn")
    public suspend fun numberOfCores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfCores = mapped
    }

    /**
     * @param value Password for login. Deprecated - use customization property
     */
    @JvmName("jrrtndnywpieeobf")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Private Cloud Id
     */
    @JvmName("rnrxbwbwiahlerxb")
    public suspend fun privateCloudId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudId = mapped
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("owqvoswxeceqfrej")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Virtual Machines Resource Pool
     */
    @JvmName("ejagrwxiwhfpmlfi")
    public suspend fun resourcePool(`value`: ResourcePoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePool = mapped
    }

    /**
     * @param argument Virtual Machines Resource Pool
     */
    @JvmName("jlsievhbswuwjjob")
    public suspend fun resourcePool(argument: suspend ResourcePoolArgsBuilder.() -> Unit) {
        val toBeMapped = ResourcePoolArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourcePool = mapped
    }

    /**
     * @param value The list of tags
     */
    @JvmName("lvjokiegasieemtw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags
     */
    @JvmName("owarylhlvfirvmdk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Virtual Machine Template Id
     */
    @JvmName("pypvmidcfvdqfkpu")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Username for login. Deprecated - use customization property
     */
    @JvmName("fwtoddprpkmsjumt")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    /**
     * @param value The list of Virtual VSphere Networks
     */
    @JvmName("gexksmrktmnbhrtr")
    public suspend fun vSphereNetworks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vSphereNetworks = mapped
    }

    /**
     * @param values The list of Virtual VSphere Networks
     */
    @JvmName("vscsuixymxlddlea")
    public suspend fun vSphereNetworks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vSphereNetworks = mapped
    }

    /**
     * @param value virtual machine name
     */
    @JvmName("fnupuapxmrvjobpw")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        amountOfRam = amountOfRam,
        customization = customization,
        disks = disks,
        exposeToGuestVM = exposeToGuestVM,
        location = location,
        nics = nics,
        numberOfCores = numberOfCores,
        password = password,
        privateCloudId = privateCloudId,
        resourceGroupName = resourceGroupName,
        resourcePool = resourcePool,
        tags = tags,
        templateId = templateId,
        username = username,
        vSphereNetworks = vSphereNetworks,
        virtualMachineName = virtualMachineName,
    )
}
