@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.azurenative.vmwarecloudsimple.VmwarecloudsimpleFunctions.getDedicatedCloudNodePlain
import com.pulumi.azurenative.vmwarecloudsimple.VmwarecloudsimpleFunctions.getDedicatedCloudServicePlain
import com.pulumi.azurenative.vmwarecloudsimple.VmwarecloudsimpleFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GetDedicatedCloudNodePlainArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GetDedicatedCloudNodePlainArgsBuilder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GetDedicatedCloudServicePlainArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GetDedicatedCloudServicePlainArgsBuilder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GetDedicatedCloudNodeResult
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GetDedicatedCloudServiceResult
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GetVirtualMachineResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GetDedicatedCloudNodeResult.Companion.toKotlin as getDedicatedCloudNodeResultToKotlin
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GetDedicatedCloudServiceResult.Companion.toKotlin as getDedicatedCloudServiceResultToKotlin
import com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin

public object VmwarecloudsimpleFunctions {
    /**
     * Returns dedicated cloud node
     * Azure REST API version: 2019-04-01.
     * @param argument null
     * @return Dedicated cloud node model
     */
    public suspend fun getDedicatedCloudNode(argument: GetDedicatedCloudNodePlainArgs):
        GetDedicatedCloudNodeResult =
        getDedicatedCloudNodeResultToKotlin(getDedicatedCloudNodePlain(argument.toJava()).await())

    /**
     * @see [getDedicatedCloudNode].
     * @param dedicatedCloudNodeName dedicated cloud node name
     * @param resourceGroupName The name of the resource group
     * @return Dedicated cloud node model
     */
    public suspend fun getDedicatedCloudNode(
        dedicatedCloudNodeName: String,
        resourceGroupName: String,
    ): GetDedicatedCloudNodeResult {
        val argument = GetDedicatedCloudNodePlainArgs(
            dedicatedCloudNodeName = dedicatedCloudNodeName,
            resourceGroupName = resourceGroupName,
        )
        return getDedicatedCloudNodeResultToKotlin(getDedicatedCloudNodePlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedCloudNode].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;vmwarecloudsimple&#46;kotlin&#46;inputs&#46;GetDedicatedCloudNodePlainArgs].
     * @return Dedicated cloud node model
     */
    public suspend
    fun getDedicatedCloudNode(argument: suspend GetDedicatedCloudNodePlainArgsBuilder.() -> Unit):
        GetDedicatedCloudNodeResult {
        val builder = GetDedicatedCloudNodePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedCloudNodeResultToKotlin(getDedicatedCloudNodePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns Dedicate Cloud Service
     * Azure REST API version: 2019-04-01.
     * @param argument null
     * @return Dedicated cloud service model
     */
    public suspend fun getDedicatedCloudService(argument: GetDedicatedCloudServicePlainArgs):
        GetDedicatedCloudServiceResult =
        getDedicatedCloudServiceResultToKotlin(getDedicatedCloudServicePlain(argument.toJava()).await())

    /**
     * @see [getDedicatedCloudService].
     * @param dedicatedCloudServiceName dedicated cloud Service name
     * @param resourceGroupName The name of the resource group
     * @return Dedicated cloud service model
     */
    public suspend fun getDedicatedCloudService(
        dedicatedCloudServiceName: String,
        resourceGroupName: String,
    ): GetDedicatedCloudServiceResult {
        val argument = GetDedicatedCloudServicePlainArgs(
            dedicatedCloudServiceName = dedicatedCloudServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getDedicatedCloudServiceResultToKotlin(getDedicatedCloudServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedCloudService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;vmwarecloudsimple&#46;kotlin&#46;inputs&#46;GetDedicatedCloudServicePlainArgs].
     * @return Dedicated cloud service model
     */
    public suspend
    fun getDedicatedCloudService(argument: suspend GetDedicatedCloudServicePlainArgsBuilder.() -> Unit):
        GetDedicatedCloudServiceResult {
        val builder = GetDedicatedCloudServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedCloudServiceResultToKotlin(getDedicatedCloudServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get virtual machine
     * Azure REST API version: 2019-04-01.
     * @param argument null
     * @return Virtual machine model
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs):
        GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param resourceGroupName The name of the resource group
     * @param virtualMachineName virtual machine name
     * @return Virtual machine model
     */
    public suspend fun getVirtualMachine(resourceGroupName: String, virtualMachineName: String):
        GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;vmwarecloudsimple&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return Virtual machine model
     */
    public suspend
    fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit):
        GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }
}
