@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudNodePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dedicatedCloudNodeName dedicated cloud node name
 * @property resourceGroupName The name of the resource group
 */
public data class GetDedicatedCloudNodePlainArgs(
    public val dedicatedCloudNodeName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudNodePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudNodePlainArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudNodePlainArgs.builder()
            .dedicatedCloudNodeName(dedicatedCloudNodeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedCloudNodePlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedCloudNodePlainArgsBuilder internal constructor() {
    private var dedicatedCloudNodeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value dedicated cloud node name
     */
    @JvmName("mirkgshtsijcborf")
    public suspend fun dedicatedCloudNodeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dedicatedCloudNodeName = mapped
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("cislajtyhvcvmqev")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDedicatedCloudNodePlainArgs = GetDedicatedCloudNodePlainArgs(
        dedicatedCloudNodeName = dedicatedCloudNodeName ?: throw
            PulumiNullFieldException("dedicatedCloudNodeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
