@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dedicatedCloudServiceName dedicated cloud Service name
 * @property resourceGroupName The name of the resource group
 */
public data class GetDedicatedCloudServicePlainArgs(
    public val dedicatedCloudServiceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudServicePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudServicePlainArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GetDedicatedCloudServicePlainArgs.builder()
            .dedicatedCloudServiceName(dedicatedCloudServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedCloudServicePlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedCloudServicePlainArgsBuilder internal constructor() {
    private var dedicatedCloudServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value dedicated cloud Service name
     */
    @JvmName("clkpficsynturlho")
    public suspend fun dedicatedCloudServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dedicatedCloudServiceName = mapped
    }

    /**
     * @param value The name of the resource group
     */
    @JvmName("nadmijcyrbdwiypj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDedicatedCloudServicePlainArgs = GetDedicatedCloudServicePlainArgs(
        dedicatedCloudServiceName = dedicatedCloudServiceName ?: throw
            PulumiNullFieldException("dedicatedCloudServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
