@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin

import com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TestLine].
 */
@PulumiTagMarker
public class TestLineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TestLineArgs = TestLineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TestLineArgsBuilder.() -> Unit) {
        val builder = TestLineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TestLine {
        val builtJavaResource = com.pulumi.azurenative.voiceservices.TestLine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TestLine(builtJavaResource)
    }
}

/**
 * A TestLine resource
 * Azure REST API version: 2023-04-03. Prior API version in Azure Native 1.x: 2022-12-01-preview.
 * Other available API versions: 2022-12-01-preview, 2023-09-01.
 * ## Example Usage
 * ### CreateTestLineResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLine = new AzureNative.VoiceServices.TestLine("testLine", new()
 *     {
 *         CommunicationsGatewayName = "myname",
 *         Location = "useast",
 *         PhoneNumber = "+1-555-1234",
 *         Purpose = AzureNative.VoiceServices.TestLinePurpose.Automated,
 *         ResourceGroupName = "testrg",
 *         TestLineName = "myline",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/voiceservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := voiceservices.NewTestLine(ctx, "testLine", &voiceservices.TestLineArgs{
 * 			CommunicationsGatewayName: pulumi.String("myname"),
 * 			Location:                  pulumi.String("useast"),
 * 			PhoneNumber:               pulumi.String("+1-555-1234"),
 * 			Purpose:                   pulumi.String(voiceservices.TestLinePurposeAutomated),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			TestLineName:              pulumi.String("myline"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.voiceservices.TestLine;
 * import com.pulumi.azurenative.voiceservices.TestLineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLine = new TestLine("testLine", TestLineArgs.builder()
 *             .communicationsGatewayName("myname")
 *             .location("useast")
 *             .phoneNumber("+1-555-1234")
 *             .purpose("Automated")
 *             .resourceGroupName("testrg")
 *             .testLineName("myline")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:voiceservices:TestLine myline /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VoiceServices/communicationsGateways/{communicationsGatewayName}/testLines/{testLineName}
 * ```
 */
public class TestLine internal constructor(
    override val javaResource: com.pulumi.azurenative.voiceservices.TestLine,
) : KotlinCustomResource(javaResource, TestLineMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The phone number
     */
    public val phoneNumber: Output<String>
        get() = javaResource.phoneNumber().applyValue({ args0 -> args0 })

    /**
     * Resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Purpose of this test line, e.g. automated or manual testing
     */
    public val purpose: Output<String>
        get() = javaResource.purpose().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TestLineMapper : ResourceMapper<TestLine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.voiceservices.TestLine::class == javaResource::class

    override fun map(javaResource: Resource): TestLine = TestLine(
        javaResource as
            com.pulumi.azurenative.voiceservices.TestLine,
    )
}

/**
 * @see [TestLine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TestLine].
 */
public suspend fun testLine(name: String, block: suspend TestLineResourceBuilder.() -> Unit):
    TestLine {
    val builder = TestLineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TestLine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun testLine(name: String): TestLine {
    val builder = TestLineResourceBuilder()
    builder.name(name)
    return builder.build()
}
