@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin

import com.pulumi.azurenative.voiceservices.TestLineArgs.builder
import com.pulumi.azurenative.voiceservices.kotlin.enums.TestLinePurpose
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A TestLine resource
 * Azure REST API version: 2023-04-03. Prior API version in Azure Native 1.x: 2022-12-01-preview.
 * Other available API versions: 2022-12-01-preview, 2023-09-01.
 * ## Example Usage
 * ### CreateTestLineResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testLine = new AzureNative.VoiceServices.TestLine("testLine", new()
 *     {
 *         CommunicationsGatewayName = "myname",
 *         Location = "useast",
 *         PhoneNumber = "+1-555-1234",
 *         Purpose = AzureNative.VoiceServices.TestLinePurpose.Automated,
 *         ResourceGroupName = "testrg",
 *         TestLineName = "myline",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/voiceservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := voiceservices.NewTestLine(ctx, "testLine", &voiceservices.TestLineArgs{
 * 			CommunicationsGatewayName: pulumi.String("myname"),
 * 			Location:                  pulumi.String("useast"),
 * 			PhoneNumber:               pulumi.String("+1-555-1234"),
 * 			Purpose:                   pulumi.String(voiceservices.TestLinePurposeAutomated),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			TestLineName:              pulumi.String("myline"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.voiceservices.TestLine;
 * import com.pulumi.azurenative.voiceservices.TestLineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLine = new TestLine("testLine", TestLineArgs.builder()
 *             .communicationsGatewayName("myname")
 *             .location("useast")
 *             .phoneNumber("+1-555-1234")
 *             .purpose("Automated")
 *             .resourceGroupName("testrg")
 *             .testLineName("myline")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:voiceservices:TestLine myline /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VoiceServices/communicationsGateways/{communicationsGatewayName}/testLines/{testLineName}
 * ```
 * @property communicationsGatewayName Unique identifier for this deployment
 * @property location The geo-location where the resource lives
 * @property phoneNumber The phone number
 * @property purpose Purpose of this test line, e.g. automated or manual testing
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property testLineName Unique identifier for this test line
 */
public data class TestLineArgs(
    public val communicationsGatewayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
    public val purpose: Output<Either<String, TestLinePurpose>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val testLineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.TestLineArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.TestLineArgs =
        com.pulumi.azurenative.voiceservices.TestLineArgs.builder()
            .communicationsGatewayName(communicationsGatewayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 }))
            .purpose(
                purpose?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .testLineName(testLineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TestLineArgs].
 */
@PulumiTagMarker
public class TestLineArgsBuilder internal constructor() {
    private var communicationsGatewayName: Output<String>? = null

    private var location: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    private var purpose: Output<Either<String, TestLinePurpose>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var testLineName: Output<String>? = null

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("exnixsnhjoqaahuj")
    public suspend fun communicationsGatewayName(`value`: Output<String>) {
        this.communicationsGatewayName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eyvibddoffvwqpju")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The phone number
     */
    @JvmName("wrqpogrnchxmycef")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value Purpose of this test line, e.g. automated or manual testing
     */
    @JvmName("rtwmtmgveexrwbmd")
    public suspend fun purpose(`value`: Output<Either<String, TestLinePurpose>>) {
        this.purpose = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gapxwkfafqfxivxg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qiyhlylpngflhpjy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique identifier for this test line
     */
    @JvmName("nrolcmdewfmeowcp")
    public suspend fun testLineName(`value`: Output<String>) {
        this.testLineName = value
    }

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("rygnsadorxauebvv")
    public suspend fun communicationsGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communicationsGatewayName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gwdwidaljunayusf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The phone number
     */
    @JvmName("yaxdompbypchokle")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    /**
     * @param value Purpose of this test line, e.g. automated or manual testing
     */
    @JvmName("lelpgqfxswqtoxpr")
    public suspend fun purpose(`value`: Either<String, TestLinePurpose>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purpose = mapped
    }

    /**
     * @param value Purpose of this test line, e.g. automated or manual testing
     */
    @JvmName("krhbaiyqxyievjki")
    public fun purpose(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TestLinePurpose>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.purpose = mapped
    }

    /**
     * @param value Purpose of this test line, e.g. automated or manual testing
     */
    @JvmName("iqqtlhnvccycuwqe")
    public fun purpose(`value`: TestLinePurpose) {
        val toBeMapped = Either.ofRight<String, TestLinePurpose>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.purpose = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ywpaojowfdgelwab")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ybwkppsxffwihmcm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kagritihltcoiinl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Unique identifier for this test line
     */
    @JvmName("mcdnjtgssaotdtvu")
    public suspend fun testLineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testLineName = mapped
    }

    internal fun build(): TestLineArgs = TestLineArgs(
        communicationsGatewayName = communicationsGatewayName,
        location = location,
        phoneNumber = phoneNumber,
        purpose = purpose,
        resourceGroupName = resourceGroupName,
        tags = tags,
        testLineName = testLineName,
    )
}
