@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.inputs

import com.pulumi.azurenative.voiceservices.inputs.GetCommunicationsGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property communicationsGatewayName Unique identifier for this deployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCommunicationsGatewayPlainArgs(
    public val communicationsGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.inputs.GetCommunicationsGatewayPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.voiceservices.inputs.GetCommunicationsGatewayPlainArgs =
        com.pulumi.azurenative.voiceservices.inputs.GetCommunicationsGatewayPlainArgs.builder()
            .communicationsGatewayName(communicationsGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommunicationsGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetCommunicationsGatewayPlainArgsBuilder internal constructor() {
    private var communicationsGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("dkohopvhmadhauhl")
    public suspend fun communicationsGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.communicationsGatewayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ikoafeskgwjwwmxp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCommunicationsGatewayPlainArgs = GetCommunicationsGatewayPlainArgs(
        communicationsGatewayName = communicationsGatewayName ?: throw
            PulumiNullFieldException("communicationsGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
