@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The service region configuration needed for Teams Callings.
 * @property name The name of the region in which the resources needed for Teams Calling will be deployed.
 * @property primaryRegionProperties The configuration used in this region as primary, and other regions as backup.
 */
public data class ServiceRegionPropertiesResponse(
    public val name: String,
    public val primaryRegionProperties: PrimaryRegionPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.outputs.ServiceRegionPropertiesResponse):
            ServiceRegionPropertiesResponse = ServiceRegionPropertiesResponse(
            name = javaType.name(),
            primaryRegionProperties = javaType.primaryRegionProperties().let({ args0 ->
                com.pulumi.azurenative.voiceservices.kotlin.outputs.PrimaryRegionPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
