@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.AppServiceEnvironmentArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.LoadBalancingMode
import com.pulumi.azurenative.web.kotlin.enums.UpgradePreference
import com.pulumi.azurenative.web.kotlin.inputs.AseV3NetworkingConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.AseV3NetworkingConfigurationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.CustomDnsSuffixConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.CustomDnsSuffixConfigurationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.NameValuePairArgs
import com.pulumi.azurenative.web.kotlin.inputs.NameValuePairArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.VirtualNetworkProfileArgs
import com.pulumi.azurenative.web.kotlin.inputs.VirtualNetworkProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * App Service Environment ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-08-01, 2020-10-01, 2021-01-15, 2023-01-01.
 * ## Example Usage
 * ### Create or update an App Service Environment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceEnvironment = new AzureNative.Web.AppServiceEnvironment("appServiceEnvironment", new()
 *     {
 *         Kind = "Asev3",
 *         Location = "South Central US",
 *         Name = "test-ase",
 *         ResourceGroupName = "test-rg",
 *         VirtualNetwork = new AzureNative.Web.Inputs.VirtualNetworkProfileArgs
 *         {
 *             Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServiceEnvironment(ctx, "appServiceEnvironment", &web.AppServiceEnvironmentArgs{
 * 			Kind:              pulumi.String("Asev3"),
 * 			Location:          pulumi.String("South Central US"),
 * 			Name:              pulumi.String("test-ase"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			VirtualNetwork: &web.VirtualNetworkProfileArgs{
 * 				Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServiceEnvironment;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentArgs;
 * import com.pulumi.azurenative.web.inputs.VirtualNetworkProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceEnvironment = new AppServiceEnvironment("appServiceEnvironment", AppServiceEnvironmentArgs.builder()
 *             .kind("Asev3")
 *             .location("South Central US")
 *             .name("test-ase")
 *             .resourceGroupName("test-rg")
 *             .virtualNetwork(VirtualNetworkProfileArgs.builder()
 *                 .id("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServiceEnvironment test-ase /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}
 * ```
 * @property clusterSettings Custom settings for changing the behavior of the App Service Environment.
 * @property customDnsSuffixConfiguration Full view of the custom domain suffix configuration for ASEv3.
 * @property dedicatedHostCount Dedicated Host Count
 * @property dnsSuffix DNS suffix of the App Service Environment.
 * @property frontEndScaleFactor Scale factor for front-ends.
 * @property internalLoadBalancingMode Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
 * @property ipsslAddressCount Number of IP SSL addresses reserved for the App Service Environment.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property multiSize Front-end VM size, e.g. "Medium", "Large".
 * @property name Name of the App Service Environment.
 * @property networkingConfiguration Full view of networking configuration for an ASE.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property tags Resource tags.
 * @property upgradePreference Upgrade Preference
 * @property userWhitelistedIpRanges User added ip ranges to whitelist on ASE db
 * @property virtualNetwork Description of the Virtual Network.
 * @property zoneRedundant Whether or not this App Service Environment is zone-redundant.
 */
public data class AppServiceEnvironmentArgs(
    public val clusterSettings: Output<List<NameValuePairArgs>>? = null,
    public val customDnsSuffixConfiguration: Output<CustomDnsSuffixConfigurationArgs>? = null,
    public val dedicatedHostCount: Output<Int>? = null,
    public val dnsSuffix: Output<String>? = null,
    public val frontEndScaleFactor: Output<Int>? = null,
    public val internalLoadBalancingMode: Output<Either<String, LoadBalancingMode>>? = null,
    public val ipsslAddressCount: Output<Int>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val multiSize: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkingConfiguration: Output<AseV3NetworkingConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upgradePreference: Output<Either<String, UpgradePreference>>? = null,
    public val userWhitelistedIpRanges: Output<List<String>>? = null,
    public val virtualNetwork: Output<VirtualNetworkProfileArgs>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.AppServiceEnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.web.AppServiceEnvironmentArgs =
        com.pulumi.azurenative.web.AppServiceEnvironmentArgs.builder()
            .clusterSettings(
                clusterSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customDnsSuffixConfiguration(
                customDnsSuffixConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .dedicatedHostCount(dedicatedHostCount?.applyValue({ args0 -> args0 }))
            .dnsSuffix(dnsSuffix?.applyValue({ args0 -> args0 }))
            .frontEndScaleFactor(frontEndScaleFactor?.applyValue({ args0 -> args0 }))
            .internalLoadBalancingMode(
                internalLoadBalancingMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .ipsslAddressCount(ipsslAddressCount?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .multiSize(multiSize?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkingConfiguration(
                networkingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upgradePreference(
                upgradePreference?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .userWhitelistedIpRanges(
                userWhitelistedIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .virtualNetwork(virtualNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServiceEnvironmentArgs].
 */
@PulumiTagMarker
public class AppServiceEnvironmentArgsBuilder internal constructor() {
    private var clusterSettings: Output<List<NameValuePairArgs>>? = null

    private var customDnsSuffixConfiguration: Output<CustomDnsSuffixConfigurationArgs>? = null

    private var dedicatedHostCount: Output<Int>? = null

    private var dnsSuffix: Output<String>? = null

    private var frontEndScaleFactor: Output<Int>? = null

    private var internalLoadBalancingMode: Output<Either<String, LoadBalancingMode>>? = null

    private var ipsslAddressCount: Output<Int>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var multiSize: Output<String>? = null

    private var name: Output<String>? = null

    private var networkingConfiguration: Output<AseV3NetworkingConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upgradePreference: Output<Either<String, UpgradePreference>>? = null

    private var userWhitelistedIpRanges: Output<List<String>>? = null

    private var virtualNetwork: Output<VirtualNetworkProfileArgs>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("xtvskjsvyxybwkue")
    public suspend fun clusterSettings(`value`: Output<List<NameValuePairArgs>>) {
        this.clusterSettings = value
    }

    @JvmName("uiyjoftpunjhljxl")
    public suspend fun clusterSettings(vararg values: Output<NameValuePairArgs>) {
        this.clusterSettings = Output.all(values.asList())
    }

    /**
     * @param values Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("ctpbchykeoahtwpt")
    public suspend fun clusterSettings(values: List<Output<NameValuePairArgs>>) {
        this.clusterSettings = Output.all(values)
    }

    /**
     * @param value Full view of the custom domain suffix configuration for ASEv3.
     */
    @JvmName("boderdwhbndvsdvg")
    public suspend
    fun customDnsSuffixConfiguration(`value`: Output<CustomDnsSuffixConfigurationArgs>) {
        this.customDnsSuffixConfiguration = value
    }

    /**
     * @param value Dedicated Host Count
     */
    @JvmName("vhpielghqhnosnni")
    public suspend fun dedicatedHostCount(`value`: Output<Int>) {
        this.dedicatedHostCount = value
    }

    /**
     * @param value DNS suffix of the App Service Environment.
     */
    @JvmName("scywohkhrlxltnfr")
    public suspend fun dnsSuffix(`value`: Output<String>) {
        this.dnsSuffix = value
    }

    /**
     * @param value Scale factor for front-ends.
     */
    @JvmName("swgwdrcpklhbsjoj")
    public suspend fun frontEndScaleFactor(`value`: Output<Int>) {
        this.frontEndScaleFactor = value
    }

    /**
     * @param value Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
     */
    @JvmName("oaesqmfocekfyrlq")
    public suspend fun internalLoadBalancingMode(`value`: Output<Either<String, LoadBalancingMode>>) {
        this.internalLoadBalancingMode = value
    }

    /**
     * @param value Number of IP SSL addresses reserved for the App Service Environment.
     */
    @JvmName("twstsnmnpnxqmvri")
    public suspend fun ipsslAddressCount(`value`: Output<Int>) {
        this.ipsslAddressCount = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("buqphlgdcpphbfhw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("oxyatqjmtopsctwu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Front-end VM size, e.g. "Medium", "Large".
     */
    @JvmName("hnjuqmrqphmlbqfx")
    public suspend fun multiSize(`value`: Output<String>) {
        this.multiSize = value
    }

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("tdxoxgpjffvpaady")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Full view of networking configuration for an ASE.
     */
    @JvmName("xclelasvgobifnly")
    public suspend fun networkingConfiguration(`value`: Output<AseV3NetworkingConfigurationArgs>) {
        this.networkingConfiguration = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("qtvjhxuwfpwnpjuc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("opfkfxpofwskoaqo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Upgrade Preference
     */
    @JvmName("qrebeaudqdxlgiky")
    public suspend fun upgradePreference(`value`: Output<Either<String, UpgradePreference>>) {
        this.upgradePreference = value
    }

    /**
     * @param value User added ip ranges to whitelist on ASE db
     */
    @JvmName("kesyiuedelximvak")
    public suspend fun userWhitelistedIpRanges(`value`: Output<List<String>>) {
        this.userWhitelistedIpRanges = value
    }

    @JvmName("iwjfcwimtmepsruw")
    public suspend fun userWhitelistedIpRanges(vararg values: Output<String>) {
        this.userWhitelistedIpRanges = Output.all(values.asList())
    }

    /**
     * @param values User added ip ranges to whitelist on ASE db
     */
    @JvmName("vdihhqileifryfio")
    public suspend fun userWhitelistedIpRanges(values: List<Output<String>>) {
        this.userWhitelistedIpRanges = Output.all(values)
    }

    /**
     * @param value Description of the Virtual Network.
     */
    @JvmName("syielyoskrmpncng")
    public suspend fun virtualNetwork(`value`: Output<VirtualNetworkProfileArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value Whether or not this App Service Environment is zone-redundant.
     */
    @JvmName("gdxyalymuautffht")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("ksrlqbrmiqpjvlab")
    public suspend fun clusterSettings(`value`: List<NameValuePairArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSettings = mapped
    }

    /**
     * @param argument Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("oqyoauqqumsiidtg")
    public suspend fun clusterSettings(argument: List<suspend NameValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clusterSettings = mapped
    }

    /**
     * @param argument Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("dsknsnrlggtchkol")
    public suspend fun clusterSettings(vararg argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clusterSettings = mapped
    }

    /**
     * @param argument Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("rsnmuwveieydvxsf")
    public suspend fun clusterSettings(argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NameValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clusterSettings = mapped
    }

    /**
     * @param values Custom settings for changing the behavior of the App Service Environment.
     */
    @JvmName("xemwgbcdkavikhip")
    public suspend fun clusterSettings(vararg values: NameValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSettings = mapped
    }

    /**
     * @param value Full view of the custom domain suffix configuration for ASEv3.
     */
    @JvmName("wadyhtficyvyfydl")
    public suspend fun customDnsSuffixConfiguration(`value`: CustomDnsSuffixConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDnsSuffixConfiguration = mapped
    }

    /**
     * @param argument Full view of the custom domain suffix configuration for ASEv3.
     */
    @JvmName("usnlituagmkldbwc")
    public suspend
    fun customDnsSuffixConfiguration(argument: suspend CustomDnsSuffixConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomDnsSuffixConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDnsSuffixConfiguration = mapped
    }

    /**
     * @param value Dedicated Host Count
     */
    @JvmName("aqympxgteevwrmar")
    public suspend fun dedicatedHostCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostCount = mapped
    }

    /**
     * @param value DNS suffix of the App Service Environment.
     */
    @JvmName("ayaqiuofhcnhlrwy")
    public suspend fun dnsSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSuffix = mapped
    }

    /**
     * @param value Scale factor for front-ends.
     */
    @JvmName("klkdrtixqherxqgg")
    public suspend fun frontEndScaleFactor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontEndScaleFactor = mapped
    }

    /**
     * @param value Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
     */
    @JvmName("jixnrprbndovfmhv")
    public suspend fun internalLoadBalancingMode(`value`: Either<String, LoadBalancingMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalLoadBalancingMode = mapped
    }

    /**
     * @param value Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
     */
    @JvmName("hvbrqmgnhwwkvror")
    public fun internalLoadBalancingMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internalLoadBalancingMode = mapped
    }

    /**
     * @param value Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
     */
    @JvmName("dedlyugjalablvox")
    public fun internalLoadBalancingMode(`value`: LoadBalancingMode) {
        val toBeMapped = Either.ofRight<String, LoadBalancingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internalLoadBalancingMode = mapped
    }

    /**
     * @param value Number of IP SSL addresses reserved for the App Service Environment.
     */
    @JvmName("rgboidpqwhphixaf")
    public suspend fun ipsslAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsslAddressCount = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ogfubugmdfekhexv")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("ppfdymbwxtlvmetq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Front-end VM size, e.g. "Medium", "Large".
     */
    @JvmName("cvfmruehvisusdvy")
    public suspend fun multiSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiSize = mapped
    }

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("ruqcbxkorphqvkaq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Full view of networking configuration for an ASE.
     */
    @JvmName("bbhdynfcmstvmmin")
    public suspend fun networkingConfiguration(`value`: AseV3NetworkingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkingConfiguration = mapped
    }

    /**
     * @param argument Full view of networking configuration for an ASE.
     */
    @JvmName("rqpvaffakaktdayw")
    public suspend
    fun networkingConfiguration(argument: suspend AseV3NetworkingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AseV3NetworkingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkingConfiguration = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vwspakcwsktmhcyi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lmgroyffjtkxyubv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gljawtwhmnmbfvks")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Upgrade Preference
     */
    @JvmName("xdvmdhhvecfhrshv")
    public suspend fun upgradePreference(`value`: Either<String, UpgradePreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradePreference = mapped
    }

    /**
     * @param value Upgrade Preference
     */
    @JvmName("uwjqfvdryxqnvwba")
    public fun upgradePreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpgradePreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradePreference = mapped
    }

    /**
     * @param value Upgrade Preference
     */
    @JvmName("dcaoydnoppqrpkhl")
    public fun upgradePreference(`value`: UpgradePreference) {
        val toBeMapped = Either.ofRight<String, UpgradePreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradePreference = mapped
    }

    /**
     * @param value User added ip ranges to whitelist on ASE db
     */
    @JvmName("efvgwpofllkkrooj")
    public suspend fun userWhitelistedIpRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userWhitelistedIpRanges = mapped
    }

    /**
     * @param values User added ip ranges to whitelist on ASE db
     */
    @JvmName("klrpmgqavcjathce")
    public suspend fun userWhitelistedIpRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userWhitelistedIpRanges = mapped
    }

    /**
     * @param value Description of the Virtual Network.
     */
    @JvmName("mljnpkbgtgeuxblf")
    public suspend fun virtualNetwork(`value`: VirtualNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument Description of the Virtual Network.
     */
    @JvmName("sqstcxuhhkkceojl")
    public suspend fun virtualNetwork(argument: suspend VirtualNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    /**
     * @param value Whether or not this App Service Environment is zone-redundant.
     */
    @JvmName("qnbxoresqlhayvep")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): AppServiceEnvironmentArgs = AppServiceEnvironmentArgs(
        clusterSettings = clusterSettings,
        customDnsSuffixConfiguration = customDnsSuffixConfiguration,
        dedicatedHostCount = dedicatedHostCount,
        dnsSuffix = dnsSuffix,
        frontEndScaleFactor = frontEndScaleFactor,
        internalLoadBalancingMode = internalLoadBalancingMode,
        ipsslAddressCount = ipsslAddressCount,
        kind = kind,
        location = location,
        multiSize = multiSize,
        name = name,
        networkingConfiguration = networkingConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
        upgradePreference = upgradePreference,
        userWhitelistedIpRanges = userWhitelistedIpRanges,
        virtualNetwork = virtualNetwork,
        zoneRedundant = zoneRedundant,
    )
}
