@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Full view of the custom domain suffix configuration for ASEv3.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Update ASE custom DNS suffix configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceEnvironmentAseCustomDnsSuffixConfiguration = new AzureNative.Web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration("appServiceEnvironmentAseCustomDnsSuffixConfiguration", new()
 *     {
 *         CertificateUrl = "https://test-kv.vault.azure.net/secrets/contosocert",
 *         DnsSuffix = "contoso.com",
 *         KeyVaultReferenceIdentity = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi",
 *         Name = "test-ase",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServiceEnvironmentAseCustomDnsSuffixConfiguration(ctx, "appServiceEnvironmentAseCustomDnsSuffixConfiguration", &web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs{
 * 			CertificateUrl:            pulumi.String("https://test-kv.vault.azure.net/secrets/contosocert"),
 * 			DnsSuffix:                 pulumi.String("contoso.com"),
 * 			KeyVaultReferenceIdentity: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi"),
 * 			Name:                      pulumi.String("test-ase"),
 * 			ResourceGroupName:         pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfiguration;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceEnvironmentAseCustomDnsSuffixConfiguration = new AppServiceEnvironmentAseCustomDnsSuffixConfiguration("appServiceEnvironmentAseCustomDnsSuffixConfiguration", AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs.builder()
 *             .certificateUrl("https://test-kv.vault.azure.net/secrets/contosocert")
 *             .dnsSuffix("contoso.com")
 *             .keyVaultReferenceIdentity("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi")
 *             .name("test-ase")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServiceEnvironmentAseCustomDnsSuffixConfiguration customDnsSuffix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix
 * ```
 * @property certificateUrl The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
 * @property dnsSuffix The default custom domain suffix to use for all sites deployed on the ASE.
 * @property keyVaultReferenceIdentity The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
 * @property kind Kind of resource.
 * @property name Name of the App Service Environment.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs(
    public val certificateUrl: Output<String>? = null,
    public val dnsSuffix: Output<String>? = null,
    public val keyVaultReferenceIdentity: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs =
        com.pulumi.azurenative.web.AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs.builder()
            .certificateUrl(certificateUrl?.applyValue({ args0 -> args0 }))
            .dnsSuffix(dnsSuffix?.applyValue({ args0 -> args0 }))
            .keyVaultReferenceIdentity(keyVaultReferenceIdentity?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs].
 */
@PulumiTagMarker
public class AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgsBuilder internal constructor() {
    private var certificateUrl: Output<String>? = null

    private var dnsSuffix: Output<String>? = null

    private var keyVaultReferenceIdentity: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
     */
    @JvmName("dklwceqrjxjrhjfo")
    public suspend fun certificateUrl(`value`: Output<String>) {
        this.certificateUrl = value
    }

    /**
     * @param value The default custom domain suffix to use for all sites deployed on the ASE.
     */
    @JvmName("crfuvpmfmnixaqgo")
    public suspend fun dnsSuffix(`value`: Output<String>) {
        this.dnsSuffix = value
    }

    /**
     * @param value The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     */
    @JvmName("lqjtnlsskymnlbjc")
    public suspend fun keyVaultReferenceIdentity(`value`: Output<String>) {
        this.keyVaultReferenceIdentity = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("smqwgghncsurerph")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("upmlfeusgtapivgu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("suxrkjoacmogbgav")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
     */
    @JvmName("dxddymeebqousqjl")
    public suspend fun certificateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateUrl = mapped
    }

    /**
     * @param value The default custom domain suffix to use for all sites deployed on the ASE.
     */
    @JvmName("ojlrllxoexorldls")
    public suspend fun dnsSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSuffix = mapped
    }

    /**
     * @param value The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     */
    @JvmName("tahxqcejapivxtja")
    public suspend fun keyVaultReferenceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultReferenceIdentity = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ymqvramjsgdytwqa")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("ckfpjknreasemqhp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ckggrsptrxjtdfie")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs =
        AppServiceEnvironmentAseCustomDnsSuffixConfigurationArgs(
            certificateUrl = certificateUrl,
            dnsSuffix = dnsSuffix,
            keyVaultReferenceIdentity = keyVaultReferenceIdentity,
            kind = kind,
            name = name,
            resourceGroupName = resourceGroupName,
        )
}
