@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ArmIdWrapperResponse
import com.pulumi.azurenative.web.kotlin.outputs.PrivateLinkConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.web.kotlin.outputs.ArmIdWrapperResponse.Companion.toKotlin as armIdWrapperResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.PrivateLinkConnectionStateResponse.Companion.toKotlin as privateLinkConnectionStateResponseToKotlin

/**
 * Builder for [AppServiceEnvironmentPrivateEndpointConnection].
 */
@PulumiTagMarker
public class AppServiceEnvironmentPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppServiceEnvironmentPrivateEndpointConnectionArgs =
        AppServiceEnvironmentPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend AppServiceEnvironmentPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = AppServiceEnvironmentPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppServiceEnvironmentPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppServiceEnvironmentPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * Remote Private Endpoint Connection ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Approves or rejects a private endpoint connection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceEnvironmentPrivateEndpointConnection = new AzureNative.Web.AppServiceEnvironmentPrivateEndpointConnection("appServiceEnvironmentPrivateEndpointConnection", new()
 *     {
 *         Name = "test-ase",
 *         PrivateEndpointConnectionName = "fa38656c-034e-43d8-adce-fe06ce039c98",
 *         PrivateLinkServiceConnectionState = new AzureNative.Web.Inputs.PrivateLinkConnectionStateArgs
 *         {
 *             Description = "Approved by johndoe@company.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServiceEnvironmentPrivateEndpointConnection(ctx, "appServiceEnvironmentPrivateEndpointConnection", &web.AppServiceEnvironmentPrivateEndpointConnectionArgs{
 * 			Name:                          pulumi.String("test-ase"),
 * 			PrivateEndpointConnectionName: pulumi.String("fa38656c-034e-43d8-adce-fe06ce039c98"),
 * 			PrivateLinkServiceConnectionState: &web.PrivateLinkConnectionStateArgs{
 * 				Description: pulumi.String("Approved by johndoe@company.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnection;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceEnvironmentPrivateEndpointConnection = new AppServiceEnvironmentPrivateEndpointConnection("appServiceEnvironmentPrivateEndpointConnection", AppServiceEnvironmentPrivateEndpointConnectionArgs.builder()
 *             .name("test-ase")
 *             .privateEndpointConnectionName("fa38656c-034e-43d8-adce-fe06ce039c98")
 *             .privateLinkServiceConnectionState(PrivateLinkConnectionStateArgs.builder()
 *                 .description("Approved by johndoe@company.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServiceEnvironmentPrivateEndpointConnection fa38656c-034e-43d8-adce-fe06ce039c98 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class AppServiceEnvironmentPrivateEndpointConnection internal constructor(
    override val javaResource:
    com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, AppServiceEnvironmentPrivateEndpointConnectionMapper) {
    /**
     * Private IPAddresses mapped to the remote private endpoint
     */
    public val ipAddresses: Output<List<String>>?
        get() = javaResource.ipAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * PrivateEndpoint of a remote private endpoint connection
     */
    public val privateEndpoint: Output<ArmIdWrapperResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> armIdWrapperResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The state of a private link connection
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppServiceEnvironmentPrivateEndpointConnectionMapper :
    ResourceMapper<AppServiceEnvironmentPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): AppServiceEnvironmentPrivateEndpointConnection =
        AppServiceEnvironmentPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnection,
        )
}

/**
 * @see [AppServiceEnvironmentPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServiceEnvironmentPrivateEndpointConnection].
 */
public suspend fun appServiceEnvironmentPrivateEndpointConnection(
    name: String,
    block: suspend AppServiceEnvironmentPrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    AppServiceEnvironmentPrivateEndpointConnection {
    val builder = AppServiceEnvironmentPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServiceEnvironmentPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServiceEnvironmentPrivateEndpointConnection(name: String):
    AppServiceEnvironmentPrivateEndpointConnection {
    val builder = AppServiceEnvironmentPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
