@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.AppServicePlanArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.web.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.HostingEnvironmentProfileArgs
import com.pulumi.azurenative.web.kotlin.inputs.HostingEnvironmentProfileArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.KubeEnvironmentProfileArgs
import com.pulumi.azurenative.web.kotlin.inputs.KubeEnvironmentProfileArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.SkuDescriptionArgs
import com.pulumi.azurenative.web.kotlin.inputs.SkuDescriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * App Service plan.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-09-01, 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create Or Update App Service plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServicePlan = new AzureNative.Web.AppServicePlan("appServicePlan", new()
 *     {
 *         Kind = "app",
 *         Location = "East US",
 *         Name = "testsf6141",
 *         ResourceGroupName = "testrg123",
 *         Sku = new AzureNative.Web.Inputs.SkuDescriptionArgs
 *         {
 *             Capacity = 1,
 *             Family = "P",
 *             Name = "P1",
 *             Size = "P1",
 *             Tier = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServicePlan(ctx, "appServicePlan", &web.AppServicePlanArgs{
 * 			Kind:              pulumi.String("app"),
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testsf6141"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Sku: &web.SkuDescriptionArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String("P"),
 * 				Name:     pulumi.String("P1"),
 * 				Size:     pulumi.String("P1"),
 * 				Tier:     pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServicePlan;
 * import com.pulumi.azurenative.web.AppServicePlanArgs;
 * import com.pulumi.azurenative.web.inputs.SkuDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServicePlan = new AppServicePlan("appServicePlan", AppServicePlanArgs.builder()
 *             .kind("app")
 *             .location("East US")
 *             .name("testsf6141")
 *             .resourceGroupName("testrg123")
 *             .sku(SkuDescriptionArgs.builder()
 *                 .capacity(1)
 *                 .family("P")
 *                 .name("P1")
 *                 .size("P1")
 *                 .tier("Premium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServicePlan testsf6141 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}
 * ```
 * @property elasticScaleEnabled ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
 * @property extendedLocation Extended Location.
 * @property freeOfferExpirationTime The time when the server farm free offer expires.
 * @property hostingEnvironmentProfile Specification for the App Service Environment to use for the App Service plan.
 * @property hyperV If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
 * @property isSpot If <code>true</code>, this App Service Plan owns spot instances.
 * @property isXenon Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
 * @property kind Kind of resource.
 * @property kubeEnvironmentProfile Specification for the Kubernetes Environment to use for the App Service plan.
 * @property location Resource Location.
 * @property maximumElasticWorkerCount Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
 * @property name Name of the App Service plan.
 * @property perSiteScaling If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
 * If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
 * @property reserved If Linux app service plan <code>true</code>, <code>false</code> otherwise.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property sku Description of a SKU for a scalable resource.
 * @property spotExpirationTime The time when the server farm expires. Valid only if it is a spot server farm.
 * @property tags Resource tags.
 * @property targetWorkerCount Scaling worker count.
 * @property targetWorkerSizeId Scaling worker size ID.
 * @property workerTierName Target worker tier assigned to the App Service plan.
 * @property zoneRedundant If <code>true</code>, this App Service Plan will perform availability zone balancing.
 * If <code>false</code>, this App Service Plan will not perform availability zone balancing.
 */
public data class AppServicePlanArgs(
    public val elasticScaleEnabled: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val freeOfferExpirationTime: Output<String>? = null,
    public val hostingEnvironmentProfile: Output<HostingEnvironmentProfileArgs>? = null,
    public val hyperV: Output<Boolean>? = null,
    public val isSpot: Output<Boolean>? = null,
    public val isXenon: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val kubeEnvironmentProfile: Output<KubeEnvironmentProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val maximumElasticWorkerCount: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val perSiteScaling: Output<Boolean>? = null,
    public val reserved: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuDescriptionArgs>? = null,
    public val spotExpirationTime: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetWorkerCount: Output<Int>? = null,
    public val targetWorkerSizeId: Output<Int>? = null,
    public val workerTierName: Output<String>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.AppServicePlanArgs> {
    override fun toJava(): com.pulumi.azurenative.web.AppServicePlanArgs =
        com.pulumi.azurenative.web.AppServicePlanArgs.builder()
            .elasticScaleEnabled(elasticScaleEnabled?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .freeOfferExpirationTime(freeOfferExpirationTime?.applyValue({ args0 -> args0 }))
            .hostingEnvironmentProfile(
                hostingEnvironmentProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hyperV(hyperV?.applyValue({ args0 -> args0 }))
            .isSpot(isSpot?.applyValue({ args0 -> args0 }))
            .isXenon(isXenon?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kubeEnvironmentProfile(
                kubeEnvironmentProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maximumElasticWorkerCount(maximumElasticWorkerCount?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .perSiteScaling(perSiteScaling?.applyValue({ args0 -> args0 }))
            .reserved(reserved?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spotExpirationTime(spotExpirationTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetWorkerCount(targetWorkerCount?.applyValue({ args0 -> args0 }))
            .targetWorkerSizeId(targetWorkerSizeId?.applyValue({ args0 -> args0 }))
            .workerTierName(workerTierName?.applyValue({ args0 -> args0 }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServicePlanArgs].
 */
@PulumiTagMarker
public class AppServicePlanArgsBuilder internal constructor() {
    private var elasticScaleEnabled: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var freeOfferExpirationTime: Output<String>? = null

    private var hostingEnvironmentProfile: Output<HostingEnvironmentProfileArgs>? = null

    private var hyperV: Output<Boolean>? = null

    private var isSpot: Output<Boolean>? = null

    private var isXenon: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var kubeEnvironmentProfile: Output<KubeEnvironmentProfileArgs>? = null

    private var location: Output<String>? = null

    private var maximumElasticWorkerCount: Output<Int>? = null

    private var name: Output<String>? = null

    private var perSiteScaling: Output<Boolean>? = null

    private var reserved: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuDescriptionArgs>? = null

    private var spotExpirationTime: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetWorkerCount: Output<Int>? = null

    private var targetWorkerSizeId: Output<Int>? = null

    private var workerTierName: Output<String>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
     */
    @JvmName("fhlpogmexxnrkxvh")
    public suspend fun elasticScaleEnabled(`value`: Output<Boolean>) {
        this.elasticScaleEnabled = value
    }

    /**
     * @param value Extended Location.
     */
    @JvmName("vlxacgshtsbhygjn")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The time when the server farm free offer expires.
     */
    @JvmName("ypoxhhplobqcdtek")
    public suspend fun freeOfferExpirationTime(`value`: Output<String>) {
        this.freeOfferExpirationTime = value
    }

    /**
     * @param value Specification for the App Service Environment to use for the App Service plan.
     */
    @JvmName("otlbhaindsxuogvu")
    public suspend fun hostingEnvironmentProfile(`value`: Output<HostingEnvironmentProfileArgs>) {
        this.hostingEnvironmentProfile = value
    }

    /**
     * @param value If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
     */
    @JvmName("aevtkxlxeunrflqp")
    public suspend fun hyperV(`value`: Output<Boolean>) {
        this.hyperV = value
    }

    /**
     * @param value If <code>true</code>, this App Service Plan owns spot instances.
     */
    @JvmName("ojbprskmusaqyvob")
    public suspend fun isSpot(`value`: Output<Boolean>) {
        this.isSpot = value
    }

    /**
     * @param value Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
     */
    @JvmName("itewmfsvsmfghsss")
    public suspend fun isXenon(`value`: Output<Boolean>) {
        this.isXenon = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xkqklkgrsnwuncvm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Specification for the Kubernetes Environment to use for the App Service plan.
     */
    @JvmName("beubohqfyxwdtfuf")
    public suspend fun kubeEnvironmentProfile(`value`: Output<KubeEnvironmentProfileArgs>) {
        this.kubeEnvironmentProfile = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("iecbqtxjuguloaxn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
     */
    @JvmName("iiawxxpduxnpjphy")
    public suspend fun maximumElasticWorkerCount(`value`: Output<Int>) {
        this.maximumElasticWorkerCount = value
    }

    /**
     * @param value Name of the App Service plan.
     */
    @JvmName("ekoggjbpepxuqune")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
     * If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
     */
    @JvmName("pfjrspptbghngeot")
    public suspend fun perSiteScaling(`value`: Output<Boolean>) {
        this.perSiteScaling = value
    }

    /**
     * @param value If Linux app service plan <code>true</code>, <code>false</code> otherwise.
     */
    @JvmName("wivlffqgwivecjcq")
    public suspend fun reserved(`value`: Output<Boolean>) {
        this.reserved = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("lsvxspehrjjebucu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Description of a SKU for a scalable resource.
     */
    @JvmName("xcrrdqikqcsjvcwp")
    public suspend fun sku(`value`: Output<SkuDescriptionArgs>) {
        this.sku = value
    }

    /**
     * @param value The time when the server farm expires. Valid only if it is a spot server farm.
     */
    @JvmName("hdotxnoqtjxaowmn")
    public suspend fun spotExpirationTime(`value`: Output<String>) {
        this.spotExpirationTime = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tlxhomhrpmqufbgt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Scaling worker count.
     */
    @JvmName("jfcwifskmcvrlkbp")
    public suspend fun targetWorkerCount(`value`: Output<Int>) {
        this.targetWorkerCount = value
    }

    /**
     * @param value Scaling worker size ID.
     */
    @JvmName("ejyvvfbhxvvprjml")
    public suspend fun targetWorkerSizeId(`value`: Output<Int>) {
        this.targetWorkerSizeId = value
    }

    /**
     * @param value Target worker tier assigned to the App Service plan.
     */
    @JvmName("kwjssqyvqlrxyxbb")
    public suspend fun workerTierName(`value`: Output<String>) {
        this.workerTierName = value
    }

    /**
     * @param value If <code>true</code>, this App Service Plan will perform availability zone balancing.
     * If <code>false</code>, this App Service Plan will not perform availability zone balancing.
     */
    @JvmName("ectemebvpyhcatnx")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
     */
    @JvmName("acchvmmoyankuwkt")
    public suspend fun elasticScaleEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticScaleEnabled = mapped
    }

    /**
     * @param value Extended Location.
     */
    @JvmName("hanqaqcukonssluv")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location.
     */
    @JvmName("kltuyruujhiestmx")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The time when the server farm free offer expires.
     */
    @JvmName("ypokrqddybsdblod")
    public suspend fun freeOfferExpirationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.freeOfferExpirationTime = mapped
    }

    /**
     * @param value Specification for the App Service Environment to use for the App Service plan.
     */
    @JvmName("snxifmfamnxmscgc")
    public suspend fun hostingEnvironmentProfile(`value`: HostingEnvironmentProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostingEnvironmentProfile = mapped
    }

    /**
     * @param argument Specification for the App Service Environment to use for the App Service plan.
     */
    @JvmName("pfvqjdjafkxktssf")
    public suspend
    fun hostingEnvironmentProfile(argument: suspend HostingEnvironmentProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HostingEnvironmentProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostingEnvironmentProfile = mapped
    }

    /**
     * @param value If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
     */
    @JvmName("rntjdlnaaimyyjcc")
    public suspend fun hyperV(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperV = mapped
    }

    /**
     * @param value If <code>true</code>, this App Service Plan owns spot instances.
     */
    @JvmName("xletyqwbnierovdg")
    public suspend fun isSpot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSpot = mapped
    }

    /**
     * @param value Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
     */
    @JvmName("rnmtgpmqmfhuyfdi")
    public suspend fun isXenon(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isXenon = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("mxxgagtcyfssievx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Specification for the Kubernetes Environment to use for the App Service plan.
     */
    @JvmName("fkhvmlhlvudmlace")
    public suspend fun kubeEnvironmentProfile(`value`: KubeEnvironmentProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeEnvironmentProfile = mapped
    }

    /**
     * @param argument Specification for the Kubernetes Environment to use for the App Service plan.
     */
    @JvmName("sjwweeynnnryidxg")
    public suspend
    fun kubeEnvironmentProfile(argument: suspend KubeEnvironmentProfileArgsBuilder.() -> Unit) {
        val toBeMapped = KubeEnvironmentProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kubeEnvironmentProfile = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("mpuaeohwqebjyqlj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
     */
    @JvmName("duebbmgyfsvphttl")
    public suspend fun maximumElasticWorkerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumElasticWorkerCount = mapped
    }

    /**
     * @param value Name of the App Service plan.
     */
    @JvmName("vnoeulyavwvinjao")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
     * If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
     */
    @JvmName("dmrkpxehxiutqoxl")
    public suspend fun perSiteScaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perSiteScaling = mapped
    }

    /**
     * @param value If Linux app service plan <code>true</code>, <code>false</code> otherwise.
     */
    @JvmName("xctubsdwilydjvku")
    public suspend fun reserved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reserved = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("lvdsuwpdayfmrebn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Description of a SKU for a scalable resource.
     */
    @JvmName("idwtxltrjsvwycif")
    public suspend fun sku(`value`: SkuDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Description of a SKU for a scalable resource.
     */
    @JvmName("wpwllmdevhkpcafi")
    public suspend fun sku(argument: suspend SkuDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = SkuDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The time when the server farm expires. Valid only if it is a spot server farm.
     */
    @JvmName("havbpgpdqmkoaukb")
    public suspend fun spotExpirationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotExpirationTime = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gmexajxyuybcnksj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jlfqqhaokrqosvyp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Scaling worker count.
     */
    @JvmName("veticoxhigkxojnx")
    public suspend fun targetWorkerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetWorkerCount = mapped
    }

    /**
     * @param value Scaling worker size ID.
     */
    @JvmName("bwpdafbeqipxpbll")
    public suspend fun targetWorkerSizeId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetWorkerSizeId = mapped
    }

    /**
     * @param value Target worker tier assigned to the App Service plan.
     */
    @JvmName("kvavxmieetepghbo")
    public suspend fun workerTierName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerTierName = mapped
    }

    /**
     * @param value If <code>true</code>, this App Service Plan will perform availability zone balancing.
     * If <code>false</code>, this App Service Plan will not perform availability zone balancing.
     */
    @JvmName("nncvsufbkjihiayj")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): AppServicePlanArgs = AppServicePlanArgs(
        elasticScaleEnabled = elasticScaleEnabled,
        extendedLocation = extendedLocation,
        freeOfferExpirationTime = freeOfferExpirationTime,
        hostingEnvironmentProfile = hostingEnvironmentProfile,
        hyperV = hyperV,
        isSpot = isSpot,
        isXenon = isXenon,
        kind = kind,
        kubeEnvironmentProfile = kubeEnvironmentProfile,
        location = location,
        maximumElasticWorkerCount = maximumElasticWorkerCount,
        name = name,
        perSiteScaling = perSiteScaling,
        reserved = reserved,
        resourceGroupName = resourceGroupName,
        sku = sku,
        spotExpirationTime = spotExpirationTime,
        tags = tags,
        targetWorkerCount = targetWorkerCount,
        targetWorkerSizeId = targetWorkerSizeId,
        workerTierName = workerTierName,
        zoneRedundant = zoneRedundant,
    )
}
