@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AppServicePlanRouteForVnet].
 */
@PulumiTagMarker
public class AppServicePlanRouteForVnetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppServicePlanRouteForVnetArgs = AppServicePlanRouteForVnetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppServicePlanRouteForVnetArgsBuilder.() -> Unit) {
        val builder = AppServicePlanRouteForVnetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppServicePlanRouteForVnet {
        val builtJavaResource =
            com.pulumi.azurenative.web.AppServicePlanRouteForVnet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppServicePlanRouteForVnet(builtJavaResource)
    }
}

/**
 * Virtual Network route contract used to pass routing information for a Virtual Network.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-09-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServicePlanRouteForVnet myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}
 * ```
 */
public class AppServicePlanRouteForVnet internal constructor(
    override val javaResource: com.pulumi.azurenative.web.AppServicePlanRouteForVnet,
) : KotlinCustomResource(javaResource, AppServicePlanRouteForVnetMapper) {
    /**
     * The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
     */
    public val endAddress: Output<String>?
        get() = javaResource.endAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of route this is:
     * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     * INHERITED - Routes inherited from the real Virtual Network routes
     * STATIC - Static route set on the app only
     * These values will be used for syncing an app's routes with those from a Virtual Network.
     */
    public val routeType: Output<String>?
        get() = javaResource.routeType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
     */
    public val startAddress: Output<String>?
        get() = javaResource.startAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppServicePlanRouteForVnetMapper : ResourceMapper<AppServicePlanRouteForVnet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.AppServicePlanRouteForVnet::class == javaResource::class

    override fun map(javaResource: Resource): AppServicePlanRouteForVnet =
        AppServicePlanRouteForVnet(
            javaResource as
                com.pulumi.azurenative.web.AppServicePlanRouteForVnet,
        )
}

/**
 * @see [AppServicePlanRouteForVnet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServicePlanRouteForVnet].
 */
public suspend fun appServicePlanRouteForVnet(
    name: String,
    block: suspend AppServicePlanRouteForVnetResourceBuilder.() -> Unit,
):
    AppServicePlanRouteForVnet {
    val builder = AppServicePlanRouteForVnetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServicePlanRouteForVnet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServicePlanRouteForVnet(name: String): AppServicePlanRouteForVnet {
    val builder = AppServicePlanRouteForVnetResourceBuilder()
    builder.name(name)
    return builder.build()
}
