@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.HostingEnvironmentProfileResponse
import com.pulumi.azurenative.web.kotlin.outputs.HostingEnvironmentProfileResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.azurenative.web.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * SSL certificate for an app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2015-08-01, 2016-03-01, 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create Or Update Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.Web.Certificate("certificate", new()
 *     {
 *         HostNames = new[]
 *         {
 *             "ServerCert",
 *         },
 *         Location = "East US",
 *         Name = "testc6282",
 *         Password = "<password>",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewCertificate(ctx, "certificate", &web.CertificateArgs{
 * 			HostNames: pulumi.StringArray{
 * 				pulumi.String("ServerCert"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testc6282"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.Certificate;
 * import com.pulumi.azurenative.web.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .hostNames("ServerCert")
 *             .location("East US")
 *             .name("testc6282")
 *             .password("<password>")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:Certificate testc6282 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates/{name}
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.azurenative.web.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * CNAME of the certificate to be issued via free certificate
     */
    public val canonicalName: Output<String>?
        get() = javaResource.canonicalName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Raw bytes of .cer file
     */
    public val cerBlob: Output<String>
        get() = javaResource.cerBlob().applyValue({ args0 -> args0 })

    /**
     * Method of domain validation for free cert
     */
    public val domainValidationMethod: Output<String>?
        get() = javaResource.domainValidationMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Certificate expiration date.
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * Friendly name of the certificate.
     */
    public val friendlyName: Output<String>
        get() = javaResource.friendlyName().applyValue({ args0 -> args0 })

    /**
     * Host names the certificate applies to.
     */
    public val hostNames: Output<List<String>>?
        get() = javaResource.hostNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Specification for the App Service Environment to use for the certificate.
     */
    public val hostingEnvironmentProfile: Output<HostingEnvironmentProfileResponse>
        get() = javaResource.hostingEnvironmentProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Certificate issue Date.
     */
    public val issueDate: Output<String>
        get() = javaResource.issueDate().applyValue({ args0 -> args0 })

    /**
     * Certificate issuer.
     */
    public val issuer: Output<String>
        get() = javaResource.issuer().applyValue({ args0 -> args0 })

    /**
     * Key Vault Csm resource Id.
     */
    public val keyVaultId: Output<String>?
        get() = javaResource.keyVaultId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key Vault secret name.
     */
    public val keyVaultSecretName: Output<String>?
        get() = javaResource.keyVaultSecretName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Status of the Key Vault secret.
     */
    public val keyVaultSecretStatus: Output<String>
        get() = javaResource.keyVaultSecretStatus().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Pfx blob.
     */
    public val pfxBlob: Output<String>?
        get() = javaResource.pfxBlob().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Public key hash.
     */
    public val publicKeyHash: Output<String>
        get() = javaResource.publicKeyHash().applyValue({ args0 -> args0 })

    /**
     * Self link.
     */
    public val selfLink: Output<String>
        get() = javaResource.selfLink().applyValue({ args0 -> args0 })

    /**
     * Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     */
    public val serverFarmId: Output<String>?
        get() = javaResource.serverFarmId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * App name.
     */
    public val siteName: Output<String>
        get() = javaResource.siteName().applyValue({ args0 -> args0 })

    /**
     * Subject name of the certificate.
     */
    public val subjectName: Output<String>
        get() = javaResource.subjectName().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Certificate thumbprint.
     */
    public val thumbprint: Output<String>
        get() = javaResource.thumbprint().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Is the certificate valid?.
     */
    public val valid: Output<Boolean>
        get() = javaResource.valid().applyValue({ args0 -> args0 })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.azurenative.web.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
